/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.security.rest;

import io.meeds.portal.security.service.SecuritySettingService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.ws.rs.Produces;
import nl.captcha.Captcha;
import nl.captcha.text.producer.DefaultTextProducer;
import nl.captcha.text.producer.TextProducer;
import nl.captcha.text.renderer.DefaultWordRenderer;
import nl.captcha.text.renderer.WordRenderer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.rest.UserFieldValidator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.web.login.recovery.PasswordRecoveryService;
import org.exoplatform.web.register.RegisterUIParamsExtension;
import org.exoplatform.web.security.security.RemindPasswordTokenService;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/login"})
@Tag(name="/login", description="Manage User action around login")
public class LoginRest {
    public static final String LOGIN_PATH = "/portal/login";
    public static final String ERROR_MESSAGE_PARAM = "error";
    public static final String SUCCESS_MESSAGE_PARAM = "success";
    public static final int CAPTCHA_WIDTH = 200;
    public static final int CAPTCHA_HEIGHT = 50;
    public static final String ONBOARDING_EMAIL_SENT_MESSAGE = "onboardingEmailSent";
    public static final String EMAIL_VERIFICATION_SENT = "emailVerificationSent";
    public static final String ADMINISTRATORS_GROUP = "/platform/administrators";
    public static final String USERS_GROUP = "/platform/users";
    public static final String EXTERNAL_USERS_GROUP = "/platform/externals";
    public static final String MEMBER = "member";
    public static final String LOCATION_HEADER = "Location";
    public static final UserFieldValidator PASSWORD_VALIDATOR = new UserFieldValidator("password", false, false, 8, 255);
    public static final UserFieldValidator EMAIL_VALIDATOR = new UserFieldValidator("email", false, false);
    public static final UserFieldValidator LASTNAME_VALIDATOR = new UserFieldValidator("lastName", false, true);
    public static final UserFieldValidator FIRSTNAME_VALIDATOR = new UserFieldValidator("firstName", false, true);
    private static final Log LOG = ExoLogger.getLogger(LoginRest.class);
    @Autowired
    private PasswordRecoveryService passwordRecoveryService;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private RegisterUIParamsExtension registerUIParamsExtension;
    @Autowired
    private SecuritySettingService securitySettingService;
    @Autowired
    private RemindPasswordTokenService remindPasswordTokenService;

    @GetMapping(path={"/verify"})
    @Produces(value={"application/json"})
    @Operation(summary="Verify user token", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public ResponseEntity<String> verifyToken(HttpServletRequest request, @Parameter(description="Token") @RequestParam(value="token") String token, @Parameter(description="Token Type") @RequestParam(name="tokenType", required=false, defaultValue="") String tokenType) {
        String username = this.passwordRecoveryService.verifyToken(token, tokenType);
        if (username != null) {
            return ResponseEntity.ok().body((Object)new JSONObject().put("username", (Object)username).toString());
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping(path={"/finishRegistration"})
    @Produces(value={"application/json"})
    @Operation(summary="Finalize external user registration", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public ResponseEntity<String> finishRegistration(HttpServletRequest request, @Parameter(description="Token") @RequestParam(value="token") String token, @Parameter(description="Token Type") @RequestParam(name="tokenType", required=false, defaultValue="") String tokenType) {
        String username = this.passwordRecoveryService.verifyToken(token, tokenType);
        if (username != null) {
            try {
                String email = this.finishUserCreation(username, request, token, request.getLocale());
                this.cleanCapcha(request.getSession(), "email-validation");
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.FOUND).header(LOCATION_HEADER, new String[]{LOGIN_PATH})).body((Object)new JSONObject().put("username", (Object)email).toString());
            }
            catch (Exception e) {
                LOG.warn((Object)"Error while registering external user", (Throwable)e);
                return ResponseEntity.internalServerError().body((Object)new JSONObject().put(ERROR_MESSAGE_PARAM, (Object)"external.registration.fail.create.user").toString());
            }
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(path={"/captcha"})
    @Produces(value={"image/png"})
    @Operation(summary="Create a captcha image", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public ResponseEntity<byte[]> serveCaptcha(HttpServletRequest request, @Parameter(description="Captcha name") @RequestParam(value="name") String name) {
        ResponseEntity responseEntity;
        Captcha captcha;
        HttpSession session = request.getSession();
        if (session.getAttribute(name) == null) {
            List<Font> textFonts = Arrays.asList(new Font("Arial", 1, 40), new Font("Courier", 1, 40));
            captcha = new Captcha.Builder(200, 50).addText((TextProducer)new DefaultTextProducer(5), (WordRenderer)new DefaultWordRenderer(Color.WHITE, textFonts)).gimp().addNoise().addBackground().build();
            session.setAttribute(name, (Object)captcha);
        } else {
            captcha = (Captcha)session.getAttribute(name);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)captcha.getImage(), "png", baos);
            byte[] bytes = baos.toByteArray();
            responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Cache-Control", new String[]{"private,no-cache,no-store"})).contentType(MediaType.valueOf((String)"image/png")).body((Object)bytes);
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return ResponseEntity.internalServerError().build();
            }
        }
        baos.close();
        return responseEntity;
    }

    @PostMapping(path={"/requestResetPassword"})
    @Produces(value={"application/json"})
    @Operation(summary="Request a reset password", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public ResponseEntity<String> requestResetPassword(HttpServletRequest request, @Parameter(description="Username") @RequestParam(value="username") String username) {
        if (username == null || username.isEmpty()) {
            return ResponseEntity.badRequest().body((Object)new JSONObject().put(ERROR_MESSAGE_PARAM, (Object)"gatein.forgotPassword.emptyUserOrEmail").toString());
        }
        User user = this.findUser(username);
        Locale locale = request.getLocale();
        if (user == null || !user.isEnabled() || this.passwordRecoveryService.sendRecoverPasswordEmail(user, locale, request)) {
            return ResponseEntity.ok((Object)new JSONObject().put(SUCCESS_MESSAGE_PARAM, (Object)"gatein.forgotPassword.emailSendSuccessful").toString());
        }
        return ResponseEntity.badRequest().body((Object)new JSONObject().put(ERROR_MESSAGE_PARAM, (Object)"gatein.forgotPassword.emailSendFailure").toString());
    }

    @PostMapping(path={"/requestRegister"})
    @Produces(value={"application/json"})
    @Operation(summary="Request for a new account", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public ResponseEntity<String> requestRegister(HttpServletRequest request, @Parameter(description="Email") @RequestParam(value="email") String email, @Parameter(description="Captcha") @RequestParam(value="captcha") String captcha) {
        if (request.getRemoteUser() != null) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.FOUND).header(LOCATION_HEADER, new String[]{"/portal"})).build();
        }
        if (!this.registerUIParamsExtension.isRegisterEnabled()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        if (!this.isValidCaptch(request.getSession(), captcha, "register")) {
            return ResponseEntity.badRequest().body((Object)new JSONObject().put(ERROR_MESSAGE_PARAM, (Object)"gatein.forgotPassword.captchaError").toString());
        }
        Locale locale = request.getLocale();
        String errorMessage = this.validateEmail(email, locale);
        if (errorMessage == null) {
            this.cleanCapcha(request.getSession(), "register");
            if (!this.isExistsEmail(email)) {
                if (this.sendOnboardingEmail(email, request)) {
                    return ResponseEntity.ok((Object)new JSONObject().put(SUCCESS_MESSAGE_PARAM, (Object)ONBOARDING_EMAIL_SENT_MESSAGE).toString());
                }
                return ResponseEntity.badRequest().body((Object)new JSONObject().put(ERROR_MESSAGE_PARAM, (Object)"gatein.forgotPassword.emailSendFailure").toString());
            }
            return ResponseEntity.ok((Object)new JSONObject().put(SUCCESS_MESSAGE_PARAM, (Object)ONBOARDING_EMAIL_SENT_MESSAGE).toString());
        }
        return ResponseEntity.badRequest().body((Object)new JSONObject().put(ERROR_MESSAGE_PARAM, (Object)errorMessage).toString());
    }

    @PostMapping(path={"/register"})
    @Produces(value={"application/json"})
    @Operation(summary="Register a new account", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public ResponseEntity<String> register(HttpServletRequest request, @Parameter(description="Email") @RequestParam(value="email") String email, @Parameter(description="Password") @RequestParam(value="password") String password, @Parameter(description="Confirm Password") @RequestParam(value="password2") String password2, @Parameter(description="Firstname") @RequestParam(value="firstName") String firsname, @Parameter(description="Lastname") @RequestParam(value="lastName") String lastname, @Parameter(description="Captcha") @RequestParam(value="captcha") String captcha, @Parameter(description="token") @RequestParam(value="token") String token) {
        if (request.getRemoteUser() != null) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.FOUND).header(LOCATION_HEADER, new String[]{"/portal"})).build();
        }
        String usernameToken = this.passwordRecoveryService.verifyToken(token, "external-registration");
        if (usernameToken == null) {
            return ResponseEntity.notFound().build();
        }
        if (this.findUser(usernameToken) != null) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.FOUND).header(LOCATION_HEADER, new String[]{LOGIN_PATH})).build();
        }
        if (!this.isValidCaptch(request.getSession(), captcha, "external-registration")) {
            return ResponseEntity.badRequest().body((Object)new JSONObject().put(ERROR_MESSAGE_PARAM, (Object)"gatein.forgotPassword.captchaError").toString());
        }
        Locale locale = request.getLocale();
        String errorMessage = this.validateUsernameAndPassword(usernameToken, null, email, password, password2, locale);
        String errorMessageName = this.validateUserFullName(firsname, lastname, locale);
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            return ResponseEntity.badRequest().body((Object)new JSONObject().put(ERROR_MESSAGE_PARAM, (Object)errorMessage).toString());
        }
        if (StringUtils.isNotBlank((CharSequence)errorMessageName)) {
            return ResponseEntity.badRequest().body((Object)new JSONObject().put(ERROR_MESSAGE_PARAM, (Object)errorMessageName).toString());
        }
        try {
            HttpSession session = request.getSession();
            String username = this.createUser(email, firsname, lastname, password);
            this.passwordRecoveryService.sendAccountCreatedConfirmationEmail(username, locale, this.getUrl(request));
            this.remindPasswordTokenService.deleteToken(token);
            this.cleanCapcha(session, "external-registration");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.FOUND).header(LOCATION_HEADER, new String[]{LOGIN_PATH})).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while registering external user", (Throwable)e);
            return ResponseEntity.internalServerError().body((Object)new JSONObject().put(ERROR_MESSAGE_PARAM, (Object)"external.registration.fail.create.user").toString());
        }
    }

    @PostMapping(path={"/verifyEmail"})
    @Produces(value={"application/json"})
    @Operation(summary="Send email verification", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public ResponseEntity<String> verifyEmail(HttpServletRequest request, @Parameter(description="Email") @RequestParam(value="email") String email, @Parameter(description="Username") @RequestParam(name="username", required=false) String username, @Parameter(description="Password") @RequestParam(value="password") String password, @Parameter(description="Confirm Password") @RequestParam(value="password2") String password2, @Parameter(description="Firstname") @RequestParam(value="firstName") String firsname, @Parameter(description="Lastname") @RequestParam(value="lastName") String lastname, @Parameter(description="Captcha") @RequestParam(value="captcha") String captcha, @Parameter(description="token") @RequestParam(value="token") String token) {
        if (request.getRemoteUser() != null) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.FOUND).header(LOCATION_HEADER, new String[]{"/portal"})).build();
        }
        String usernameToken = this.passwordRecoveryService.verifyToken(token, "external-registration");
        if (usernameToken == null) {
            return ResponseEntity.notFound().build();
        }
        if (this.findUser(usernameToken) != null) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.FOUND).header(LOCATION_HEADER, new String[]{LOGIN_PATH})).build();
        }
        if (!this.isValidCaptch(request.getSession(), captcha, "external-registration")) {
            return ResponseEntity.badRequest().body((Object)new JSONObject().put(ERROR_MESSAGE_PARAM, (Object)"gatein.forgotPassword.captchaError").toString());
        }
        Locale locale = request.getLocale();
        String errorMessage = this.validateUsernameAndPassword(usernameToken, username, email, password, password2, locale);
        String errorMessageName = this.validateUserFullName(firsname, lastname, locale);
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            return ResponseEntity.badRequest().body((Object)new JSONObject().put(ERROR_MESSAGE_PARAM, (Object)errorMessage).toString());
        }
        if (StringUtils.isNotBlank((CharSequence)errorMessageName)) {
            return ResponseEntity.badRequest().body((Object)new JSONObject().put(ERROR_MESSAGE_PARAM, (Object)errorMessageName).toString());
        }
        User user = this.organizationService.getUserHandler().createUserInstance(username);
        user.setFirstName(firsname);
        user.setLastName(lastname);
        user.setEmail(email);
        user.setPassword(password);
        String data = this.generateUserDetailCredential(user);
        this.passwordRecoveryService.sendAccountVerificationEmail(data, username, firsname, lastname, email, locale, this.getUrl(request));
        return ResponseEntity.ok((Object)new JSONObject().put(SUCCESS_MESSAGE_PARAM, (Object)EMAIL_VERIFICATION_SENT).toString());
    }

    @PostMapping(path={"/resetPassword"})
    @Produces(value={"application/json"})
    @Operation(summary="Reset password", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public ResponseEntity<String> resetPassword(HttpServletRequest request, @Parameter(description="Username") @RequestParam(value="username") String username, @Parameter(description="Password") @RequestParam(value="password") String password, @Parameter(description="Confirm Password") @RequestParam(value="password2") String password2, @Parameter(description="token") @RequestParam(value="token") String token) {
        String usernameToken = this.passwordRecoveryService.verifyToken(token, "forgot-password");
        if (usernameToken == null) {
            return ResponseEntity.notFound().build();
        }
        Locale locale = request.getLocale();
        String errorMessage = this.validateUserAndPassword(usernameToken, username, password, password2, locale);
        if (errorMessage == null) {
            if (this.passwordRecoveryService.changePass(token, "forgot-password", username, password)) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.FOUND).header(LOCATION_HEADER, new String[]{LOGIN_PATH})).build();
            }
            return ResponseEntity.badRequest().body((Object)new JSONObject().put(ERROR_MESSAGE_PARAM, (Object)"gatein.forgotPassword.resetPasswordFailure").toString());
        }
        return ResponseEntity.badRequest().body((Object)new JSONObject().put(ERROR_MESSAGE_PARAM, (Object)errorMessage).toString());
    }

    @PostMapping(path={"/setPassword"})
    @Produces(value={"application/json"})
    @Operation(summary="Set password", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public ResponseEntity<String> setPassword(HttpServletRequest request, @Parameter(description="Username") @RequestParam(value="username") String username, @Parameter(description="Password") @RequestParam(value="password") String password, @Parameter(description="Confirm Password") @RequestParam(value="password2") String password2, @Parameter(description="token") @RequestParam(value="token") String token, @Parameter(description="captcha") @RequestParam(value="captcha") String captcha) {
        String usernameToken = this.passwordRecoveryService.verifyToken(token, "onboard");
        if (usernameToken == null) {
            return ResponseEntity.notFound().build();
        }
        if (!this.isValidCaptch(request.getSession(), captcha, "on-boarding")) {
            return ResponseEntity.badRequest().body((Object)new JSONObject().put(ERROR_MESSAGE_PARAM, (Object)"gatein.forgotPassword.captchaError").toString());
        }
        Locale locale = request.getLocale();
        String errorMessage = this.validateUserAndPassword(usernameToken, username, password, password2, locale);
        if (errorMessage == null) {
            if (this.passwordRecoveryService.changePass(token, "onboard", username, password)) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.FOUND).header(LOCATION_HEADER, new String[]{LOGIN_PATH})).build();
            }
            return ResponseEntity.badRequest().body((Object)new JSONObject().put(ERROR_MESSAGE_PARAM, (Object)"gatein.forgotPassword.resetPasswordFailure").toString());
        }
        return ResponseEntity.badRequest().body((Object)new JSONObject().put(ERROR_MESSAGE_PARAM, (Object)errorMessage).toString());
    }

    private User findUser(String usernameOrEmail) {
        User user = null;
        try {
            user = this.organizationService.getUserHandler().findUserByName(usernameOrEmail, UserStatus.ANY);
            if (user == null && usernameOrEmail.contains("@")) {
                Query query = new Query();
                usernameOrEmail = usernameOrEmail.replace("*", "");
                query.setEmail(usernameOrEmail);
                ListAccess list = this.organizationService.getUserHandler().findUsersByQuery(query, UserStatus.ANY);
                if (list != null && list.getSize() > 0) {
                    user = ((User[])list.load(0, 1))[0];
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("An error occurred while searching for user with username/email: " + usernameOrEmail), (Throwable)e);
        }
        return user;
    }

    private String validateUserAndPassword(String tokenUsername, String requestedUsername, String password, String confirmPass, Locale locale) {
        if (requestedUsername == null || !requestedUsername.equals(tokenUsername)) {
            return "gatein.forgotPassword.usernameChanged";
        }
        if (!StringUtils.equals((CharSequence)password, (CharSequence)confirmPass)) {
            return "gatein.forgotPassword.confirmPasswordNotMatch";
        }
        String errorMessage = PASSWORD_VALIDATOR.validate(locale, password);
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            return errorMessage;
        }
        return null;
    }

    private boolean isValidCaptch(HttpSession session, String captchaValue, String name) {
        Captcha captcha = (Captcha)session.getAttribute(name);
        return captcha != null && captcha.isCorrect(captchaValue);
    }

    private String validateUsernameAndPassword(String tokenUsernameOrEmail, String username, String email, String password, String confirmPass, Locale locale) {
        boolean notSameUser;
        boolean isEmailToken = StringUtils.contains((CharSequence)tokenUsernameOrEmail, (CharSequence)"@");
        boolean bl = notSameUser = StringUtils.isBlank((CharSequence)tokenUsernameOrEmail) || StringUtils.isBlank((CharSequence)username) && StringUtils.isBlank((CharSequence)email) || isEmailToken && !StringUtils.equals((CharSequence)tokenUsernameOrEmail, (CharSequence)email) || !isEmailToken && !StringUtils.equals((CharSequence)tokenUsernameOrEmail, (CharSequence)username);
        if (notSameUser) {
            return "gatein.forgotPassword.usernameChanged";
        }
        String errorMessage = PASSWORD_VALIDATOR.validate(locale, password);
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            return errorMessage;
        }
        if (!isEmailToken) {
            errorMessage = EMAIL_VALIDATOR.validate(locale, email);
            if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
                return errorMessage;
            }
        } else if (!StringUtils.equals((CharSequence)password, (CharSequence)confirmPass)) {
            return "gatein.forgotPassword.confirmPasswordNotMatch";
        }
        return null;
    }

    private String validateUserFullName(String firstName, String lastName, Locale locale) {
        String errorMessage = FIRSTNAME_VALIDATOR.validate(locale, firstName);
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            return errorMessage;
        }
        errorMessage = LASTNAME_VALIDATOR.validate(locale, lastName);
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            return errorMessage;
        }
        return null;
    }

    private String validateEmail(String email, Locale locale) {
        return EMAIL_VALIDATOR.validate(locale, email);
    }

    private boolean isExistsEmail(String email) {
        try {
            Query query = new Query();
            query.setEmail(email);
            ListAccess users = this.organizationService.getUserHandler().findUsersByQuery(query, UserStatus.ANY);
            if (users != null && users.getSize() > 0) {
                return true;
            }
            User user = this.organizationService.getUserHandler().findUserByName(email);
            if (user != null) {
                return true;
            }
        }
        catch (Exception e) {
            LOG.error("Error retrieving users list with email {}. Thus, we will consider the email as already used", new Object[]{email, e});
            return true;
        }
        return false;
    }

    private boolean sendOnboardingEmail(String email, HttpServletRequest request) {
        try {
            StringBuilder url = this.getUrl(request);
            Locale locale = request.getLocale();
            this.passwordRecoveryService.sendExternalRegisterEmail(null, email, locale, null, url, false);
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to send onboarding email", (Throwable)e);
            return false;
        }
        return true;
    }

    private StringBuilder getUrl(HttpServletRequest request) {
        StringBuilder url = new StringBuilder();
        if (request != null) {
            url.append(request.getScheme()).append("://").append(request.getServerName());
            if (request.getServerPort() != 80 && request.getServerPort() != 443) {
                url.append(':').append(request.getServerPort());
            }
            url.append("/").append(PortalContainer.getCurrentPortalContainerName());
        }
        return url;
    }

    private void cleanCapcha(HttpSession session, String name) {
        session.removeAttribute(name);
    }

    private String createUser(String email, String firstName, String lastName, String password) throws Exception {
        User user = this.organizationService.getUserHandler().createUserInstance(null);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setPassword(password);
        user.setEmail(email);
        return this.createUser(user);
    }

    private String createUser(User user) throws Exception {
        Collection memberships;
        boolean isAdministrator;
        String login = user.getUserName();
        if (StringUtils.isBlank((CharSequence)login)) {
            login = this.generateUsername(user.getFirstName(), user.getLastName());
            user.setUserName(login);
        }
        this.organizationService.getUserHandler().createUser(user, true);
        RequestLifeCycle.restartTransaction();
        if (this.securitySettingService.isRegistrationExternalUser() && !(isAdministrator = CollectionUtils.isNotEmpty((Collection)(memberships = this.organizationService.getMembershipHandler().findMembershipsByUserAndGroup(login, ADMINISTRATORS_GROUP))))) {
            this.deleteFromInternalUsersGroup(login);
            RequestLifeCycle.restartTransaction();
            this.addToExternalUsersGroup(login);
        }
        return login;
    }

    private String generateUsername(String firstname, String lastname) {
        String userNameBase = (firstname.replaceAll("\\s", "") + "." + lastname.replaceAll("\\s", "")).toLowerCase();
        userNameBase = this.unAccent(userNameBase);
        Object username = userNameBase;
        Random rand = new Random();
        while (this.findUser((String)username) != null) {
            int num = rand.nextInt(89) + 10;
            username = userNameBase + num;
        }
        return username;
    }

    private void deleteFromInternalUsersGroup(String username) throws Exception {
        Collection usersMemberhips = this.organizationService.getMembershipHandler().findMembershipsByUserAndGroup(username, USERS_GROUP);
        if (CollectionUtils.isNotEmpty((Collection)usersMemberhips)) {
            for (Membership usersMemberhip : usersMemberhips) {
                this.organizationService.getMembershipHandler().removeMembership(usersMemberhip.getId(), true);
            }
        }
    }

    private void addToExternalUsersGroup(String username) throws Exception {
        Collection externalsUsersMemberhips = this.organizationService.getMembershipHandler().findMembershipsByUserAndGroup(username, EXTERNAL_USERS_GROUP);
        if (CollectionUtils.isNotEmpty((Collection)externalsUsersMemberhips)) {
            for (Membership usersMemberhip : externalsUsersMemberhips) {
                this.organizationService.getMembershipHandler().removeMembership(usersMemberhip.getId(), true);
            }
        }
        this.organizationService.getMembershipHandler().linkMembership(this.organizationService.getUserHandler().findUserByName(username), this.organizationService.getGroupHandler().findGroupById(EXTERNAL_USERS_GROUP), this.organizationService.getMembershipTypeHandler().findMembershipType(MEMBER), true);
    }

    private String unAccent(String src) {
        return Normalizer.normalize(src, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "").replace("'", "").replace("`", "");
    }

    private String generateUserDetailCredential(User user) {
        return String.format("%s::%s::%s::%s::%s", user.getUserName(), user.getFirstName(), user.getLastName(), user.getEmail(), user.getPassword());
    }

    private String finishUserCreation(String username, HttpServletRequest request, String token, Locale locale) throws Exception {
        User user = this.generateUserFromCredential(username);
        username = this.createUser(user);
        this.passwordRecoveryService.sendAccountCreatedConfirmationEmail(username, locale, this.getUrl(request));
        this.remindPasswordTokenService.deleteToken(token);
        return user.getEmail();
    }

    private User generateUserFromCredential(String data) {
        String[] dataParts = StringUtils.split((String)data, (String)"::");
        User user = this.organizationService.getUserHandler().createUserInstance(dataParts[0]);
        user.setFirstName(dataParts[1]);
        user.setLastName(dataParts[2]);
        user.setEmail(dataParts[3]);
        String firstPart = dataParts[0] + "::" + dataParts[1] + "::" + dataParts[2] + "::" + dataParts[3] + "::";
        String password = data.substring(firstPart.length());
        user.setPassword(password);
        return user;
    }
}

