/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.listener.social;

import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import io.meeds.social.category.model.Category;
import jakarta.annotation.PostConstruct;
import java.util.Date;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnalyticsCategoryListener
extends Listener<Category, Long> {
    @Autowired
    private ListenerService listenerService;

    @PostConstruct
    public void init() {
        this.listenerService.addListener("social.category.created", (ListenerBase)this);
        this.listenerService.addListener("social.category.updated", (ListenerBase)this);
        this.listenerService.addListener("social.category.deleted", (ListenerBase)this);
    }

    public void onEvent(Event<Category, Long> event) throws Exception {
        StatisticData statisticData = new StatisticData();
        statisticData.setTimestamp(new Date().getTime());
        statisticData.setModule("social");
        statisticData.setSubModule("category");
        switch (event.getEventName()) {
            case "social.category.created": {
                statisticData.setOperation("categoryCreated");
                break;
            }
            case "social.category.updated": {
                statisticData.setOperation("categoryUpdated");
                break;
            }
            case "social.category.deleted": {
                statisticData.setOperation("categoryDeleted");
                break;
            }
        }
        AnalyticsUtils.addCategoryStatistics((StatisticData)statisticData, (Category)((Category)event.getSource()));
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }
}

