/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.mvc;

import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.server.ExposesResourceFor;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.Assert;

public class ControllerLinkRelationProvider
implements LinkRelationProvider {
    private final Class<?> controllerType;
    private final Class<?> entityType;
    private final PluginRegistry<LinkRelationProvider, LinkRelationProvider.LookupContext> providers;

    public ControllerLinkRelationProvider(Class<?> controller, PluginRegistry<LinkRelationProvider, LinkRelationProvider.LookupContext> providers) {
        Assert.notNull(controller, (String)"Controller must not be null!");
        Assert.notNull(providers, (String)"LinkRelationProviders must not be null!");
        ExposesResourceFor annotation = (ExposesResourceFor)AnnotatedElementUtils.findMergedAnnotation(controller, ExposesResourceFor.class);
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Controller %s must be annotated with @ExposesResourceFor(\u2026)!", controller.getName()));
        }
        this.controllerType = controller;
        this.entityType = annotation.value();
        this.providers = providers;
    }

    @Override
    public LinkRelation getItemResourceRelFor(Class<?> resource) {
        LinkRelationProvider.LookupContext context = LinkRelationProvider.LookupContext.forItemResourceRelLookup(this.entityType);
        return ((LinkRelationProvider)this.providers.getRequiredPluginFor((Object)context)).getItemResourceRelFor(resource);
    }

    @Override
    public LinkRelation getCollectionResourceRelFor(Class<?> resource) {
        LinkRelationProvider.LookupContext context = LinkRelationProvider.LookupContext.forCollectionResourceRelLookup(this.entityType);
        return ((LinkRelationProvider)this.providers.getRequiredPluginFor((Object)context)).getCollectionResourceRelFor(resource);
    }

    @Override
    public boolean supports(LinkRelationProvider.LookupContext context) {
        return context.handlesType(this.controllerType);
    }
}

