/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.spi;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.type.descriptor.java.ArrayJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.hibernate.type.descriptor.java.spi.EntityJavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeBaseline;
import org.hibernate.type.descriptor.java.spi.JavaTypeBasicAdaptor;
import org.hibernate.type.descriptor.java.spi.RegistryHelper;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.type.spi.TypeConfigurationAware;
import org.jboss.logging.Logger;

public class JavaTypeRegistry
implements JavaTypeBaseline.BaselineTarget,
Serializable {
    private static final Logger log = Logger.getLogger(JavaTypeRegistry.class);
    private final TypeConfiguration typeConfiguration;
    private final ConcurrentHashMap<Type, JavaType<?>> descriptorsByType = new ConcurrentHashMap();

    public JavaTypeRegistry(TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
        JavaTypeBaseline.prime(this);
    }

    @Override
    public void addBaselineDescriptor(JavaType<?> descriptor) {
        if (descriptor.getJavaType() == null) {
            throw new IllegalStateException("Illegal to add BasicJavaType with null Java type");
        }
        this.addBaselineDescriptor(descriptor.getJavaType(), descriptor);
    }

    @Override
    public void addBaselineDescriptor(Type describedJavaType, JavaType<?> descriptor) {
        this.performInjections(descriptor);
        this.descriptorsByType.put(describedJavaType, descriptor);
    }

    private void performInjections(JavaType<?> descriptor) {
        if (descriptor instanceof TypeConfigurationAware) {
            ((TypeConfigurationAware)((Object)descriptor)).setTypeConfiguration(this.typeConfiguration);
        }
    }

    public void forEachDescriptor(Consumer<JavaType<?>> consumer) {
        this.descriptorsByType.values().forEach(consumer);
    }

    public <T> JavaType<T> getDescriptor(Type javaType) {
        return this.resolveDescriptor(javaType);
    }

    public void addDescriptor(JavaType<?> descriptor) {
        JavaType<?> old = this.descriptorsByType.put(descriptor.getJavaType(), descriptor);
        if (old != null) {
            log.debugf("JavaTypeRegistry entry replaced : %s -> %s (was %s)", (Object)descriptor.getJavaType(), descriptor, old);
        }
        this.performInjections(descriptor);
    }

    public <J> JavaType<J> findDescriptor(Type javaType) {
        return this.descriptorsByType.get(javaType);
    }

    public <J> JavaType<J> resolveDescriptor(Type javaType, Supplier<JavaType<J>> creator) {
        JavaType<?> cached = this.descriptorsByType.get(javaType);
        if (cached != null) {
            return cached;
        }
        JavaType<J> created = creator.get();
        this.descriptorsByType.put(javaType, created);
        return created;
    }

    public <J> JavaType<J> resolveDescriptor(Type javaType) {
        return this.resolveDescriptor(javaType, (Type elementJavaType, TypeConfiguration typeConfiguration) -> {
            MutabilityPlan determinedPlan = RegistryHelper.INSTANCE.determineMutabilityPlan((Type)elementJavaType, (TypeConfiguration)typeConfiguration);
            if (determinedPlan != null) {
                return determinedPlan;
            }
            return MutableMutabilityPlan.INSTANCE;
        });
    }

    public <J> JavaType<J> resolveDescriptor(Type javaType, BiFunction<Type, TypeConfiguration, MutabilityPlan<?>> mutabilityPlanCreator) {
        return this.resolveDescriptor(javaType, () -> {
            JavaType elementTypeDescriptor;
            Class<?> elementJavaType;
            ParameterizedType parameterizedType;
            JavaType rawType;
            if (javaType instanceof ParameterizedType && (rawType = this.findDescriptor((parameterizedType = (ParameterizedType)((Object)javaType)).getRawType())) != null) {
                return rawType.createJavaType(parameterizedType, this.typeConfiguration);
            }
            if (javaType instanceof Class && ((Class)javaType).isArray()) {
                elementJavaType = ((Class)javaType).getComponentType();
                elementTypeDescriptor = this.findDescriptor(elementJavaType);
            } else {
                elementJavaType = javaType;
                elementTypeDescriptor = null;
            }
            if (elementTypeDescriptor == null) {
                elementTypeDescriptor = RegistryHelper.INSTANCE.createTypeDescriptor(elementJavaType, () -> (MutabilityPlan)mutabilityPlanCreator.apply(elementJavaType, this.typeConfiguration), this.typeConfiguration);
            }
            if (javaType != elementJavaType) {
                return new ArrayJavaType(elementTypeDescriptor);
            }
            return elementTypeDescriptor;
        });
    }

    public <J> JavaType<J> resolveManagedTypeDescriptor(Type javaType) {
        return this.resolveManagedTypeDescriptor(javaType, false);
    }

    public <J> JavaType<J> resolveEntityTypeDescriptor(Type javaType) {
        return this.resolveManagedTypeDescriptor(javaType, true);
    }

    private <J> JavaType<J> resolveManagedTypeDescriptor(Type javaType, boolean entity) {
        return this.resolveDescriptor(javaType, () -> {
            Class javaTypeClass;
            if (javaType instanceof Class) {
                javaTypeClass = (Class)javaType;
            } else {
                ParameterizedType parameterizedType = (ParameterizedType)javaType;
                javaTypeClass = (Class)parameterizedType.getRawType();
            }
            MutabilityPlan determinedPlan = RegistryHelper.INSTANCE.determineMutabilityPlan(javaType, this.typeConfiguration);
            MutabilityPlan mutabilityPlan = determinedPlan != null ? determinedPlan : MutableMutabilityPlan.INSTANCE;
            return entity ? new EntityJavaType(javaTypeClass, mutabilityPlan) : new JavaTypeBasicAdaptor(javaTypeClass, mutabilityPlan);
        });
    }
}

