/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.util.Objects;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.type.descriptor.java.JavaType;

public interface ModelPart
extends MappingModelExpressible {
    public NavigableRole getNavigableRole();

    public String getPartName();

    public MappingType getPartMappingType();

    public JavaType<?> getJavaType();

    default public boolean isVirtual() {
        return false;
    }

    default public boolean isEntityIdentifierMapping() {
        return false;
    }

    public boolean hasPartitionedSelectionMapping();

    public <T> DomainResult<T> createDomainResult(NavigablePath var1, TableGroup var2, String var3, DomainResultCreationState var4);

    public void applySqlSelections(NavigablePath var1, TableGroup var2, DomainResultCreationState var3);

    public void applySqlSelections(NavigablePath var1, TableGroup var2, DomainResultCreationState var3, BiConsumer<SqlSelection, JdbcMapping> var4);

    default public int forEachSelectable(SelectableConsumer consumer) {
        return this.forEachSelectable(0, consumer);
    }

    default public int forEachSelectable(int offset, SelectableConsumer consumer) {
        return 0;
    }

    default public AttributeMapping asAttributeMapping() {
        return null;
    }

    default public EntityMappingType asEntityMappingType() {
        return null;
    }

    default public @Nullable BasicValuedModelPart asBasicValuedModelPart() {
        return null;
    }

    default public int breakDownJdbcValues(Object domainValue, JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        return this.breakDownJdbcValues(domainValue, 0, null, null, valueConsumer, session);
    }

    public <X, Y> int breakDownJdbcValues(Object var1, int var2, X var3, Y var4, JdbcValueBiConsumer<X, Y> var5, SharedSessionContractImplementor var6);

    default public int decompose(Object domainValue, JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        return this.decompose(domainValue, 0, null, null, valueConsumer, session);
    }

    default public <X, Y> int decompose(Object domainValue, int offset, X x, Y y, JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        return this.breakDownJdbcValues(domainValue, offset, x, y, valueConsumer, session);
    }

    public EntityMappingType findContainingEntityMapping();

    default public boolean areEqual(@Nullable Object one, @Nullable Object other, SharedSessionContractImplementor session) {
        return Objects.deepEquals(one, other);
    }

    @FunctionalInterface
    public static interface JdbcValueBiConsumer<X, Y> {
        public void consume(int var1, X var2, Y var3, Object var4, SelectableMapping var5);
    }

    @FunctionalInterface
    public static interface JdbcValueConsumer
    extends JdbcValueBiConsumer<Object, Object> {
        @Override
        default public void consume(int valueIndex, Object x, Object y, Object value, SelectableMapping jdbcValueMapping) {
            this.consume(valueIndex, value, jdbcValueMapping);
        }

        public void consume(int var1, Object var2, SelectableMapping var3);
    }
}

