/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.DataStreamLifecycle;
import co.elastic.clients.elasticsearch.indices.DataStreamLifecycleRolloverConditions;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataStreamLifecycleWithRollover
extends DataStreamLifecycle {
    @Nullable
    private final DataStreamLifecycleRolloverConditions rollover;
    public static final JsonpDeserializer<DataStreamLifecycleWithRollover> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreamLifecycleWithRollover::setupDataStreamLifecycleWithRolloverDeserializer);

    private DataStreamLifecycleWithRollover(Builder builder) {
        super(builder);
        this.rollover = builder.rollover;
    }

    public static DataStreamLifecycleWithRollover of(Function<Builder, ObjectBuilder<DataStreamLifecycleWithRollover>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final DataStreamLifecycleRolloverConditions rollover() {
        return this.rollover;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.rollover != null) {
            generator.writeKey("rollover");
            this.rollover.serialize(generator, mapper);
        }
    }

    protected static void setupDataStreamLifecycleWithRolloverDeserializer(ObjectDeserializer<Builder> op) {
        DataStreamLifecycle.setupDataStreamLifecycleDeserializer(op);
        op.add(Builder::rollover, DataStreamLifecycleRolloverConditions._DESERIALIZER, "rollover");
    }

    public static class Builder
    extends DataStreamLifecycle.AbstractBuilder<Builder>
    implements ObjectBuilder<DataStreamLifecycleWithRollover> {
        @Nullable
        private DataStreamLifecycleRolloverConditions rollover;

        public final Builder rollover(@Nullable DataStreamLifecycleRolloverConditions value) {
            this.rollover = value;
            return this;
        }

        public final Builder rollover(Function<DataStreamLifecycleRolloverConditions.Builder, ObjectBuilder<DataStreamLifecycleRolloverConditions>> fn) {
            return this.rollover(fn.apply(new DataStreamLifecycleRolloverConditions.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataStreamLifecycleWithRollover build() {
            this._checkSingleUse();
            return new DataStreamLifecycleWithRollover(this);
        }
    }
}

