/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core.init;

import liquibase.command.core.init.AbstractCommandLineValueGetter;
import liquibase.util.StringUtil;

public class StringGetter
extends AbstractCommandLineValueGetter<String> {
    private final boolean allowEmpty;

    public StringGetter(boolean allowEmpty) {
        super(String.class);
        this.allowEmpty = allowEmpty;
    }

    @Override
    public boolean validate(String input) {
        if (this.allowEmpty) {
            return true;
        }
        return StringUtil.isNotEmpty(input);
    }

    @Override
    public String convert(String input) {
        return input;
    }

    @Override
    public String describe() {
        if (this.allowEmpty) {
            return "string";
        }
        return "non-empty string";
    }
}

