/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.listener.social;

import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import jakarta.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnalyticsActivityListener
extends ActivityListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(AnalyticsActivityListener.class);
    @Autowired
    private ActivityManager activityManager;
    @Autowired
    private SpaceService spaceService;

    @PostConstruct
    public void init() {
        this.activityManager.addActivityEventListener((ActivityListenerPlugin)this);
    }

    public void saveActivity(ActivityLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addActivityStatisticEvent(event, "createActivity");
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void updateActivity(ActivityLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addActivityStatisticEvent(event, "updateActivity");
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void deleteActivity(ActivityLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addActivityStatisticEvent(event, "deleteActivity");
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void shareActivity(ActivityLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addActivityStatisticEvent(event, "shareActivity");
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void saveComment(ActivityLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addActivityStatisticEvent(event, "createComment");
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void updateComment(ActivityLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addActivityStatisticEvent(event, "updateComment");
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void deleteComment(ActivityLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addActivityStatisticEvent(event, "deleteComment");
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void likeActivity(ActivityLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addActivityStatisticEvent(event, "likeActivity");
            this.addLikeIdentityId(statisticData, event);
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void likeComment(ActivityLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addActivityStatisticEvent(event, "likeComment");
            this.addLikeIdentityId(statisticData, event);
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void pinActivity(ActivityLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addActivityStatisticEvent(event, "pinActivity");
            statisticData.setUserId(Long.parseLong(event.getUserId()));
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    private void handleErrorProcessingOperation(ActivityLifeCycleEvent event, Exception exception) {
        LOG.warn("Error adding Statistic data for activity {} with event {}", new Object[]{event.getActivityId(), event.getType(), exception});
    }

    private void addLikeIdentityId(StatisticData statisticData, ActivityLifeCycleEvent event) {
        String[] likeIdentityIds = event.getActivity().getLikeIdentityIds();
        if (likeIdentityIds != null && likeIdentityIds.length > 0) {
            String likerId = likeIdentityIds[likeIdentityIds.length - 1];
            statisticData.addParameter("likeIdentityId", (Object)likerId);
        }
    }

    private StatisticData addActivityStatisticEvent(ActivityLifeCycleEvent event, String operation) {
        ActivityStream activityStream;
        ExoSocialActivity activity = event.getActivity();
        long modifierUserId = AnalyticsUtils.getCurrentUserIdentityId();
        if (modifierUserId == 0L) {
            try {
                long identityId = Long.parseLong(activity.getPosterId());
                Identity identity = AnalyticsUtils.getIdentity((String)activity.getPosterId());
                if (identity != null && StringUtils.equals((CharSequence)identity.getProviderId(), (CharSequence)"organization")) {
                    modifierUserId = identityId;
                }
            }
            catch (NumberFormatException e1) {
                modifierUserId = AnalyticsUtils.getUserIdentityId((String)activity.getPosterId());
            }
        }
        if (modifierUserId == 0L) {
            modifierUserId = AnalyticsUtils.getCurrentUserIdentityId();
        }
        if (((activityStream = activity.getActivityStream()) == null || activityStream.getType() == null || activityStream.getPrettyId() == null) && StringUtils.isNotBlank((CharSequence)activity.getParentId())) {
            ExoSocialActivity parentActivity = this.activityManager.getActivity(activity.getParentId());
            activityStream = parentActivity.getActivityStream();
        }
        Identity streamIdentity = null;
        if (activityStream != null) {
            ActivityStream.Type type = activityStream.getType();
            boolean isSpace = type == ActivityStream.Type.SPACE;
            String streamProviderId = isSpace ? "space" : "organization";
            String streamRemoteId = activityStream.getPrettyId();
            try {
                streamIdentity = AnalyticsUtils.getIdentity((String)streamProviderId, (String)streamRemoteId);
            }
            catch (Exception e) {
                LOG.debug("Can't retrieve identity with providerId {} and remoteId {}. Attempt to retrieve it as Identity technical ID", new Object[]{streamProviderId, streamRemoteId, e});
                streamIdentity = AnalyticsUtils.getIdentity((String)activityStream.getId());
            }
        }
        StatisticData statisticData = new StatisticData();
        if (streamIdentity != null) {
            if (StringUtils.equals((CharSequence)streamIdentity.getProviderId(), (CharSequence)"space")) {
                Space space = this.spaceService.getSpaceByPrettyName(streamIdentity.getRemoteId());
                AnalyticsUtils.addSpaceStatistics((StatisticData)statisticData, (Space)space);
            }
            statisticData.addParameter("streamIdentityId", (Object)streamIdentity.getIdentityId());
        }
        statisticData.setModule("social");
        statisticData.setSubModule("activity");
        statisticData.setOperation(operation);
        statisticData.setUserId(modifierUserId);
        AnalyticsUtils.addActivityStatisticsData((StatisticData)statisticData, (ExoSocialActivity)activity);
        return statisticData;
    }
}

