/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.content.link.rest;

import io.meeds.content.link.model.Link;
import io.meeds.content.link.model.LinkSetting;
import io.meeds.content.link.rest.model.LinkSettingRestEntity;
import io.meeds.content.link.rest.util.LinkEntityBuilder;
import io.meeds.content.link.service.LinkService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.social.rest.api.RestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"links"})
@Tag(name="/content/rest/links", description="Managing links for Links Application")
public class LinkRest {
    @Autowired
    private LinkService linkService;

    @GetMapping(path={"{name}"}, produces={"application/json"})
    @Operation(summary="Retrieves a link application settings with associated links", description="Retrieves a link application settings with associated links", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="304", description="Not modified"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Resource not found")})
    public ResponseEntity<LinkSettingRestEntity> getLinkSetting(WebRequest request, @Parameter(description="Link name", required=true) @PathVariable(value="name") String name, @Parameter(description="User language", required=false) @RequestParam(name="lang", required=false) String lang) {
        try {
            LinkSetting linkSetting = this.linkService.getLinkSettingByName(name, lang, RestUtils.getCurrentUserAclIdentity());
            if (linkSetting == null) {
                return ResponseEntity.notFound().build();
            }
            LinkSettingRestEntity linkSettingEntity = this.getLinkSettingEntity(linkSetting, lang);
            String eTag = String.valueOf(linkSettingEntity.hashCode());
            if (request.checkNotModified(eTag)) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_MODIFIED).build();
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().eTag(eTag)).body((Object)linkSettingEntity);
        }
        catch (IllegalAccessException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
    }

    @PutMapping(path={"{name}"}, produces={"application/json"}, consumes={"application/json"})
    @Secured(value={"users"})
    @Operation(summary="Saves a link application settings with associated links", description="Saves a link application settings with associated links", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized")})
    public LinkSettingRestEntity saveLinkSetting(WebRequest request, @Parameter(description="Link name", required=true) @PathVariable(value="name") String name, @RequestBody LinkSettingRestEntity linkSettingEntity) {
        try {
            LinkSetting linkSetting = LinkEntityBuilder.toLinkSetting(linkSettingEntity);
            List<Link> linksToSave = LinkEntityBuilder.toLinks(linkSettingEntity);
            linkSetting = this.linkService.saveLinkSetting(linkSetting, linksToSave, RestUtils.getCurrentUserAclIdentity());
            return this.getLinkSettingEntity(linkSetting, null);
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, e.getMessage());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
    }

    @GetMapping(path={"{name}/{id}/icon"}, produces={"image/png"})
    @Operation(summary="Gets a link icon specified by setting name and link id", method="GET", description="Gets a link icon specified by setting name and link id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="304", description="Not modified"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Resource not found")})
    public ResponseEntity<InputStreamResource> getLinkIcon(WebRequest request, @Parameter(description="Link name", required=true) @PathVariable(value="name") String name, @Parameter(description="Link id", required=true) @PathVariable(value="id") long id) {
        try {
            LinkSetting linkSetting = this.linkService.getLinkSettingByName(name, null, RestUtils.getCurrentUserAclIdentity());
            if (linkSetting == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            String eTag = String.valueOf(linkSetting.hashCode());
            if (request.checkNotModified(eTag)) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_MODIFIED).build();
            }
            InputStream stream = this.linkService.getLinkIconStream(linkSetting.getName(), id);
            if (stream == null) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build();
            }
            ResponseEntity.BodyBuilder builder = ResponseEntity.ok();
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)builder.contentType(MediaType.IMAGE_PNG).lastModified(linkSetting.getLastModified())).eTag(eTag)).body((Object)new InputStreamResource(stream));
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, e.getMessage());
        }
        catch (IOException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
    }

    private LinkSettingRestEntity getLinkSettingEntity(LinkSetting linkSetting, String lang) {
        List<Link> links = this.linkService.getLinks(linkSetting.getName(), lang, true);
        return LinkEntityBuilder.build(linkSetting, links);
    }
}

