/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.application.portlet;

import java.io.Writer;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.StateAwareResponse;
import javax.portlet.WindowState;
import lombok.Generated;
import org.exoplatform.commons.utils.WriterPrinter;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.application.URLBuilder;
import org.exoplatform.web.url.PortalURL;
import org.exoplatform.web.url.ResourceType;
import org.exoplatform.web.url.URLFactory;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletURLBuilder;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;

public class PortletRequestContext
extends WebuiRequestContext {
    private String windowId;
    private PortletRequest request;
    private PortletResponse response;
    private Writer writer;
    private PortletMode portletMode = PortletMode.VIEW;
    private WindowState windowState = WindowState.NORMAL;
    private boolean portletInPortal = true;
    private boolean isAppLifecycleStarted = false;
    private PortletURLBuilder urlBuilder;

    public PortletRequestContext(RequestContext parentAppRequestContext, WebuiApplication app, Writer writer, PortletRequest req, PortletResponse res) {
        super(parentAppRequestContext, app);
        this.init(writer, req, res);
        this.setSessionId(req.getPortletSession(true).getId());
    }

    public void init(Writer writer, PortletRequest req, PortletResponse res) {
        this.request = req;
        this.response = res;
        this.writer = new WriterPrinter(writer);
        this.windowId = req.getWindowID();
        if (res instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)res;
            this.urlBuilder = new PortletURLBuilder(mimeResponse.createActionURL());
        } else {
            this.urlBuilder = null;
        }
    }

    public <R, U extends PortalURL<R, U>> U newURL(ResourceType<R, U> resourceType, URLFactory urlFactory) {
        return (U)this.parentAppRequestContext_.newURL(resourceType, urlFactory);
    }

    @Override
    public void setUIApplication(UIApplication uiApplication) throws Exception {
        this.uiApplication_ = uiApplication;
        this.appRes_ = this.getApplication().getResourceBundle(this.getParentAppRequestContext().getLocale());
    }

    public final String getRequestParameter(String name) {
        return this.request.getParameter(name);
    }

    public final String[] getRequestParameterValues(String name) {
        return this.request.getParameterValues(name);
    }

    public Orientation getOrientation() {
        return this.parentAppRequestContext_.getOrientation();
    }

    @Override
    public String getRequestContextPath() {
        return this.request.getContextPath();
    }

    @Override
    public String getPortalContextPath() {
        RequestContext requestContext = this.parentAppRequestContext_;
        if (requestContext instanceof WebuiRequestContext) {
            WebuiRequestContext requestContext2 = (WebuiRequestContext)requestContext;
            return requestContext2.getPortalContextPath();
        }
        return null;
    }

    public URLFactory getURLFactory() {
        return this.parentAppRequestContext_.getURLFactory();
    }

    public String getRemoteUser() {
        return this.parentAppRequestContext_.getRemoteUser();
    }

    public final boolean isUserInRole(String roleUser) {
        return this.request.isUserInRole(roleUser);
    }

    public final boolean useAjax() {
        return this.getParentAppRequestContext().useAjax();
    }

    @Override
    public void sendRedirect(String url) throws Exception {
        this.setResponseComplete(true);
        PortletResponse portletResponse = this.response;
        if (portletResponse instanceof ActionResponse) {
            ActionResponse actionResponse = (ActionResponse)portletResponse;
            actionResponse.sendRedirect(url);
        }
    }

    public UserPortal getUserPortal() {
        return this.getParentAppRequestContext().getUserPortal();
    }

    @Override
    public URLBuilder<UIComponent> getURLBuilder() {
        if (this.urlBuilder == null) {
            throw new IllegalStateException("Cannot create portlet URL during action/event phase");
        }
        return this.urlBuilder;
    }

    public PortletMode getApplicationMode() {
        return this.request.getPortletMode();
    }

    public void setApplicationMode(PortletMode mode) throws PortletModeException {
        PortletResponse portletResponse = this.response;
        if (!(portletResponse instanceof StateAwareResponse)) {
            throw new PortletModeException("The portlet don't support to set a portlet mode by current runtime environment", mode);
        }
        StateAwareResponse stateResponse = (StateAwareResponse)portletResponse;
        stateResponse.setPortletMode(mode);
    }

    public boolean isAppLifecycleStarted() {
        return this.isAppLifecycleStarted;
    }

    public void setAppLifecycleStarted(boolean b) {
        this.isAppLifecycleStarted = b;
    }

    public static PortletRequestContext getCurrentInstance() {
        RequestContext currentInstance = RequestContext.getCurrentInstance();
        if (currentInstance != null && currentInstance instanceof PortletRequestContext) {
            PortletRequestContext portletRequestContext = (PortletRequestContext)currentInstance;
            return portletRequestContext;
        }
        return null;
    }

    public static PortletMode getCurrentPortletMode() {
        PortletRequestContext portletRequestContext = PortletRequestContext.getCurrentInstance();
        return portletRequestContext == null ? PortletMode.VIEW : portletRequestContext.getPortletMode();
    }

    public static void setCurrentPortletMode(PortletMode mode) {
        PortletRequestContext portletRequestContext = PortletRequestContext.getCurrentInstance();
        if (portletRequestContext != null) {
            portletRequestContext.setPortletMode(mode);
        }
    }

    public static WindowState getCurrentWindowState() {
        PortletRequestContext portletRequestContext = PortletRequestContext.getCurrentInstance();
        return portletRequestContext == null ? WindowState.NORMAL : portletRequestContext.getWindowState();
    }

    public static void setCurrentWindowState(WindowState state) {
        PortletRequestContext portletRequestContext = PortletRequestContext.getCurrentInstance();
        if (portletRequestContext != null) {
            portletRequestContext.setWindowState(state);
        }
    }

    @Generated
    public String getWindowId() {
        return this.windowId;
    }

    @Generated
    public PortletRequest getRequest() {
        return this.request;
    }

    @Generated
    public PortletResponse getResponse() {
        return this.response;
    }

    @Generated
    public Writer getWriter() {
        return this.writer;
    }

    @Generated
    public PortletMode getPortletMode() {
        return this.portletMode;
    }

    @Generated
    public WindowState getWindowState() {
        return this.windowState;
    }

    @Generated
    public boolean isPortletInPortal() {
        return this.portletInPortal;
    }

    @Generated
    public void setWindowId(String windowId) {
        this.windowId = windowId;
    }

    @Generated
    public void setRequest(PortletRequest request) {
        this.request = request;
    }

    @Generated
    public void setResponse(PortletResponse response) {
        this.response = response;
    }

    @Generated
    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    @Generated
    public void setPortletMode(PortletMode portletMode) {
        this.portletMode = portletMode;
    }

    @Generated
    public void setWindowState(WindowState windowState) {
        this.windowState = windowState;
    }

    @Generated
    public void setPortletInPortal(boolean portletInPortal) {
        this.portletInPortal = portletInPortal;
    }

    @Generated
    public void setUrlBuilder(PortletURLBuilder urlBuilder) {
        this.urlBuilder = urlBuilder;
    }

    @Generated
    public String toString() {
        return "PortletRequestContext(windowId=" + this.getWindowId() + ", request=" + String.valueOf(this.getRequest()) + ", response=" + String.valueOf(this.getResponse()) + ", writer=" + String.valueOf(this.getWriter()) + ", portletMode=" + String.valueOf(this.getPortletMode()) + ", windowState=" + String.valueOf(this.getWindowState()) + ", portletInPortal=" + this.isPortletInPortal() + ", isAppLifecycleStarted=" + this.isAppLifecycleStarted() + ", urlBuilder=" + String.valueOf(this.getURLBuilder()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PortletRequestContext)) {
            return false;
        }
        PortletRequestContext other = (PortletRequestContext)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isPortletInPortal() != other.isPortletInPortal()) {
            return false;
        }
        if (this.isAppLifecycleStarted() != other.isAppLifecycleStarted()) {
            return false;
        }
        String this$windowId = this.getWindowId();
        String other$windowId = other.getWindowId();
        if (this$windowId == null ? other$windowId != null : !this$windowId.equals(other$windowId)) {
            return false;
        }
        URLBuilder<UIComponent> this$urlBuilder = this.getURLBuilder();
        URLBuilder<UIComponent> other$urlBuilder = other.getURLBuilder();
        return !(this$urlBuilder == null ? other$urlBuilder != null : !this$urlBuilder.equals(other$urlBuilder));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PortletRequestContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPortletInPortal() ? 79 : 97);
        result = result * 59 + (this.isAppLifecycleStarted() ? 79 : 97);
        String $windowId = this.getWindowId();
        result = result * 59 + ($windowId == null ? 43 : $windowId.hashCode());
        URLBuilder<UIComponent> $urlBuilder = this.getURLBuilder();
        result = result * 59 + ($urlBuilder == null ? 43 : $urlBuilder.hashCode());
        return result;
    }
}

