/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.metamodel.internal.StandardEmbeddableInstantiator;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.BatchEntityInsideEmbeddableSelectFetchInitializer;
import org.hibernate.sql.results.graph.entity.internal.BatchEntitySelectFetchInitializer;
import org.hibernate.sql.results.graph.entity.internal.BatchInitializeEntitySelectFetchInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntitySelectFetchByUniqueKeyInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntitySelectFetchInitializer;

public class EntitySelectFetchInitializerBuilder {
    public static EntityInitializer<?> createInitializer(InitializerParent<?> parent, ToOneAttributeMapping fetchedAttribute, EntityPersister entityPersister, DomainResult<?> keyResult, NavigablePath navigablePath, boolean selectByUniqueKey, boolean affectedByFilter, AssemblerCreationState creationState) {
        if (selectByUniqueKey) {
            return new EntitySelectFetchByUniqueKeyInitializer(parent, fetchedAttribute, navigablePath, entityPersister, keyResult, affectedByFilter, creationState);
        }
        if (!parent.isEntityInitializer() && parent.findOwningEntityInitializer() == null) {
            return new EntitySelectFetchInitializer(parent, fetchedAttribute, navigablePath, entityPersister, keyResult, affectedByFilter, creationState);
        }
        BatchMode batchMode = EntitySelectFetchInitializerBuilder.determineBatchMode(entityPersister, parent, creationState);
        switch (batchMode) {
            case NONE: {
                return new EntitySelectFetchInitializer(parent, fetchedAttribute, navigablePath, entityPersister, keyResult, affectedByFilter, creationState);
            }
            case BATCH_LOAD: {
                if (parent.isEmbeddableInitializer()) {
                    return new BatchEntityInsideEmbeddableSelectFetchInitializer(parent, fetchedAttribute, navigablePath, entityPersister, keyResult, affectedByFilter, creationState);
                }
                return new BatchEntitySelectFetchInitializer(parent, fetchedAttribute, navigablePath, entityPersister, keyResult, affectedByFilter, creationState);
            }
            case BATCH_INITIALIZE: {
                return new BatchInitializeEntitySelectFetchInitializer(parent, fetchedAttribute, navigablePath, entityPersister, keyResult, affectedByFilter, creationState);
            }
        }
        throw new IllegalStateException("Should be unreachable");
    }

    private static BatchMode determineBatchMode(EntityPersister entityPersister, InitializerParent<?> parent, AssemblerCreationState creationState) {
        if (!entityPersister.isBatchLoadable()) {
            return BatchMode.NONE;
        }
        if (creationState.isDynamicInstantiation()) {
            if (EntitySelectFetchInitializerBuilder.canBatchInitializeBeUsed(entityPersister)) {
                return BatchMode.BATCH_INITIALIZE;
            }
            return BatchMode.NONE;
        }
        while (parent.isEmbeddableInitializer()) {
            EmbeddableInitializer<?> embeddableInitializer = parent.asEmbeddableInitializer();
            EmbeddableValuedModelPart initializedPart = embeddableInitializer.getInitializedPart();
            if (initializedPart.isEntityIdentifierMapping() || initializedPart.isVirtual() || initializedPart.getMappedType().isPolymorphic() || !(initializedPart.getMappedType().getRepresentationStrategy().getInstantiator() instanceof StandardEmbeddableInstantiator)) {
                return entityPersister.hasSubclasses() ? BatchMode.NONE : BatchMode.BATCH_INITIALIZE;
            }
            if ((parent = parent.getParent()) != null) continue;
            break;
        }
        if (parent != null) {
            assert (parent.getInitializedPart() instanceof EntityValuedModelPart);
            EntityPersister parentPersister = parent.asEntityInitializer().getEntityDescriptor();
            EntityDataAccess cacheAccess = parentPersister.getCacheAccessStrategy();
            if (cacheAccess != null) {
                if (EntitySelectFetchInitializerBuilder.canBatchInitializeBeUsed(entityPersister)) {
                    return BatchMode.BATCH_INITIALIZE;
                }
                return BatchMode.NONE;
            }
        }
        return BatchMode.BATCH_LOAD;
    }

    private static boolean canBatchInitializeBeUsed(EntityPersister entityPersister) {
        return entityPersister.getRepresentationStrategy().getProxyFactory() != null;
    }

    static enum BatchMode {
        NONE,
        BATCH_LOAD,
        BATCH_INITIALIZE;

    }
}

