/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.ext;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.cometd.bayeux.BinaryData;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.common.Z85;

public class BinaryExtension
implements BayeuxServer.Extension {
    private final boolean decodeToByteBuffer;

    public BinaryExtension() {
        this(true);
    }

    public BinaryExtension(boolean decodeToByteBuffer) {
        this.decodeToByteBuffer = decodeToByteBuffer;
    }

    public boolean rcv(ServerSession from, ServerMessage.Mutable message) {
        Map ext = message.getExt();
        if (ext != null && ext.remove("binary") != null) {
            Map data = message.getDataAsMap();
            BinaryData newData = new BinaryData(data);
            message.setData((Object)newData);
            String encoded = (String)data.get("data");
            Object decoded = this.decodeToByteBuffer ? Z85.decoder.decodeByteBuffer(encoded) : (Object)Z85.decoder.decodeBytes(encoded);
            newData.put((Object)"data", decoded);
        }
        return true;
    }

    public boolean send(ServerSession from, ServerSession to, ServerMessage.Mutable message) {
        Object data = message.getData();
        if (data instanceof BinaryData) {
            String encoded;
            BinaryData binaryData = (BinaryData)data;
            Object binary = binaryData.get((Object)"data");
            if (binary instanceof byte[]) {
                encoded = Z85.encoder.encodeBytes(binaryData.asBytes());
            } else if (binary instanceof ByteBuffer) {
                encoded = Z85.encoder.encodeByteBuffer(binaryData.asByteBuffer());
            } else {
                throw new IllegalArgumentException("Cannot Z85 encode " + binary);
            }
            HashMap<String, String> newData = new HashMap<String, String>((Map<String, String>)binaryData);
            newData.put("data", encoded);
            message.setData(newData);
            Map ext = message.getExt(true);
            ext.put("binary", new HashMap(0));
        }
        return true;
    }
}

