/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ConnectorScheduling
implements JsonpSerializable {
    private final boolean enabled;
    private final String interval;
    public static final JsonpDeserializer<ConnectorScheduling> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ConnectorScheduling::setupConnectorSchedulingDeserializer);

    private ConnectorScheduling(Builder builder) {
        this.enabled = ApiTypeHelper.requireNonNull(builder.enabled, (Object)this, "enabled", false);
        this.interval = ApiTypeHelper.requireNonNull(builder.interval, this, "interval");
    }

    public static ConnectorScheduling of(Function<Builder, ObjectBuilder<ConnectorScheduling>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean enabled() {
        return this.enabled;
    }

    public final String interval() {
        return this.interval;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("enabled");
        generator.write(this.enabled);
        generator.writeKey("interval");
        generator.write(this.interval);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupConnectorSchedulingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
        op.add(Builder::interval, JsonpDeserializer.stringDeserializer(), "interval");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ConnectorScheduling> {
        private Boolean enabled;
        private String interval;

        public final Builder enabled(boolean value) {
            this.enabled = value;
            return this;
        }

        public final Builder interval(String value) {
            this.interval = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ConnectorScheduling build() {
            this._checkSingleUse();
            return new ConnectorScheduling(this);
        }
    }
}

