/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application.localization;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.localization.HttpRequestWrapper;
import org.exoplatform.portal.localization.LocaleContextInfoUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.LocalePolicy;

public class LocalizationFilter
extends AbstractFilter {
    private static Log log = ExoLogger.getLogger((String)"portal:LocalizationFilter");
    private static ThreadLocal<Locale> currentLocale = new ThreadLocal();
    private Locale portalLocale = Locale.ENGLISH;

    protected void afterInit(FilterConfig config) throws ServletException {
        String locale = config.getInitParameter("PortalLocale");
        String string = locale = locale != null ? locale.trim() : null;
        if (locale != null && locale.length() > 0) {
            this.portalLocale = LocaleContextInfo.getLocale((String)locale);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        try {
            Locale locale;
            PortalRequestContext context = PortalRequestContext.getCurrentInstance();
            if (context != null && context.getLocale() != null) {
                boolean skipWrapping = currentLocale.get() != null;
                currentLocale.set(context.getLocale());
                if (!skipWrapping) {
                    req = new HttpRequestWrapper((HttpServletRequest)req);
                }
                chain.doFilter((ServletRequest)req, (ServletResponse)res);
                return;
            }
            if (currentLocale.get() != null) {
                chain.doFilter(request, response);
                return;
            }
            ExoContainer container = this.getContainer();
            if (container == null) {
                chain.doFilter((ServletRequest)req, (ServletResponse)res);
                return;
            }
            LocalePolicy localePolicy = (LocalePolicy)container.getComponentInstanceOfType(LocalePolicy.class);
            LocaleContextInfo localeCtx = LocaleContextInfoUtils.buildLocaleContextInfo((HttpServletRequest)req);
            Set supportedLocales = LocaleContextInfoUtils.getSupportedLocales();
            boolean supported = supportedLocales.contains(locale = localePolicy.determineLocale(localeCtx));
            if (!supported && !"".equals(locale.getCountry())) {
                locale = new Locale(locale.getLanguage());
                supported = supportedLocales.contains(locale);
            }
            if (!supported) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Unsupported locale returned by LocalePolicy: " + String.valueOf(localePolicy) + ". Falling back to 'en'."));
                }
                locale = Locale.ENGLISH;
            }
            currentLocale.set(locale);
            chain.doFilter((ServletRequest)new HttpRequestWrapper((HttpServletRequest)req), (ServletResponse)res);
        }
        catch (Exception e) {
            throw new RuntimeException("LocalizationFilter exception: ", e);
        }
        finally {
            currentLocale.remove();
        }
    }

    public void destroy() {
    }

    public static Locale getCurrentLocale() {
        return currentLocale.get();
    }
}

