/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.idgenerator.impl;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Random;
import org.exoplatform.services.idgenerator.IDGeneratorService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class IDGeneratorServiceImpl
implements IDGeneratorService {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.component.common.IDGeneratorServiceImpl");
    private static String hexServerIP_;
    private static IntegerFormatter integerFormatter;
    private static final Random seeder_;

    public IDGeneratorServiceImpl() {
        if (hexServerIP_ == null) {
            throw new IllegalStateException("The local inet address could not be found");
        }
    }

    @Override
    public Serializable generateID(Object o) {
        return this.generateStringID(o);
    }

    @Override
    public long generateLongID(Object o) {
        String uuid = this.generateStringID(o);
        return uuid.hashCode();
    }

    @Override
    public int generatIntegerID(Object o) {
        String uuid = this.generateStringID(o);
        return uuid.hashCode();
    }

    @Override
    public String generateStringID(Object o) {
        return this.generateStringID(o, System.currentTimeMillis(), hexServerIP_, seeder_.nextInt());
    }

    protected String generateStringID(Object o, long timeNow, String hexServerIP, int node) {
        StringBuilder guid = new StringBuilder(32);
        int timeLow = (int)timeNow & 0xFFFFFFFF;
        IDGeneratorServiceImpl.addHexFormat(guid, timeLow, 8);
        guid.append(hexServerIP);
        IDGeneratorServiceImpl.addHexFormat(guid, System.identityHashCode(o), 8);
        IDGeneratorServiceImpl.addHexFormat(guid, node, 8);
        return guid.toString();
    }

    private static int getInt(byte[] bytes) {
        int i = 0;
        int j = 24;
        int k = 0;
        while (j >= 0) {
            int l = bytes[k] & 0xFF;
            i += l << j;
            j -= 8;
            ++k;
        }
        return i;
    }

    private static String hexFormat(int i, int j) {
        StringBuilder buffer = new StringBuilder(j);
        IDGeneratorServiceImpl.addHexFormat(buffer, i, j);
        return buffer.toString();
    }

    private static void addHexFormat(StringBuilder buffer, int i, int j) {
        String s = integerFormatter.toHexString(i);
        IDGeneratorServiceImpl.addPadHex(buffer, s, j);
        buffer.append(s);
    }

    private static void addPadHex(StringBuilder buffer, String s, int i) {
        int length = s.length();
        if (length < i) {
            for (int j = 0; j < i - length; ++j) {
                buffer.append('0');
            }
        }
    }

    static {
        integerFormatter = "IBM Corporation".equals(System.getProperty("java.vendor")) && "1.8.0".equals(System.getProperty("java.version")) ? new J9IntegerFormatter() : new IntegerFormatter();
        InetAddress localInetAddress = null;
        try {
            localInetAddress = InetAddress.getLocalHost();
            byte[] serverIP = localInetAddress.getAddress();
            hexServerIP_ = IDGeneratorServiceImpl.hexFormat(IDGeneratorServiceImpl.getInt(serverIP), 8);
        }
        catch (UnknownHostException uhe) {
            LOG.fatal((Object)uhe.getLocalizedMessage(), (Throwable)uhe);
        }
        seeder_ = new SecureRandom();
    }

    private static class IntegerFormatter {
        private IntegerFormatter() {
        }

        public String toHexString(int i) {
            return Integer.toHexString(i);
        }
    }

    private static class J9IntegerFormatter
    extends IntegerFormatter {
        private J9IntegerFormatter() {
        }

        @Override
        public String toHexString(int i) {
            String hex = Integer.toHexString(i);
            int lastNul = hex.lastIndexOf(0);
            if (lastNul >= 0) {
                return hex.substring(lastNul + 1);
            }
            return hex;
        }
    }
}

