/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.CompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.StandardVirtualTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.embeddable.EmbeddableValuedFetchable;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableFetchImpl;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableResultImpl;

public abstract class AbstractCompositeIdentifierMapping
implements CompositeIdentifierMapping,
EmbeddableValuedFetchable,
FetchOptions {
    private final NavigableRole navigableRole;
    private final String tableExpression;
    private final EntityMappingType entityMapping;
    protected final SessionFactoryImplementor sessionFactory;

    public AbstractCompositeIdentifierMapping(EntityMappingType entityMapping, String tableExpression, MappingModelCreationProcess creationProcess) {
        this.navigableRole = entityMapping.getNavigableRole().appendContainer("{id}");
        this.entityMapping = entityMapping;
        this.tableExpression = tableExpression;
        this.sessionFactory = creationProcess.getCreationContext().getSessionFactory();
    }

    protected AbstractCompositeIdentifierMapping(AbstractCompositeIdentifierMapping original) {
        this.navigableRole = original.navigableRole;
        this.entityMapping = original.entityMapping;
        this.tableExpression = original.tableExpression;
        this.sessionFactory = original.sessionFactory;
    }

    @Override
    public boolean hasContainingClass() {
        return true;
    }

    @Override
    public EmbeddableMappingType getMappedType() {
        return this.getPartMappingType();
    }

    @Override
    public EmbeddableMappingType getEmbeddableTypeDescriptor() {
        return this.getPartMappingType();
    }

    @Override
    public String getContainingTableExpression() {
        return this.tableExpression;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        return new EmbeddableFetchImpl(fetchablePath, this, fetchParent, fetchTiming, selected, creationState);
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, @Nullable String explicitSourceAlias, @Nullable SqlAliasBase explicitSqlAliasBase, @Nullable SqlAstJoinType requestedJoinType, boolean fetched, boolean addsPredicate, SqlAstCreationState creationState) {
        SqlAstJoinType joinType = this.determineSqlJoinType(lhs, requestedJoinType, fetched);
        TableGroup tableGroup = this.createRootTableGroupJoin(navigablePath, lhs, explicitSourceAlias, explicitSqlAliasBase, requestedJoinType, fetched, null, creationState);
        return new TableGroupJoin(navigablePath, joinType, tableGroup, null);
    }

    @Override
    public TableGroup createRootTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, @Nullable String explicitSourceAlias, @Nullable SqlAliasBase explicitSqlAliasBase, @Nullable SqlAstJoinType sqlAstJoinType, boolean fetched, @Nullable Consumer<Predicate> predicateConsumer, SqlAstCreationState creationState) {
        return new StandardVirtualTableGroup(navigablePath, this, lhs, fetched);
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        return this.getPartMappingType().findSubPart(name, treatTargetType);
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        this.getPartMappingType().visitSubParts(consumer, treatTargetType);
    }

    @Override
    public <X, Y> int forEachJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        int span = 0;
        EmbeddableMappingType embeddableTypeDescriptor = this.getEmbeddableTypeDescriptor();
        int size = embeddableTypeDescriptor.getNumberOfAttributeMappings();
        if (value == null) {
            for (int i = 0; i < size; ++i) {
                AttributeMapping attributeMapping = embeddableTypeDescriptor.getAttributeMapping(i);
                span += attributeMapping.forEachJdbcValue(null, span + offset, x, y, valuesConsumer, session);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                AttributeMapping attributeMapping = embeddableTypeDescriptor.getAttributeMapping(i);
                Object o = embeddableTypeDescriptor.getValue(value, i);
                if (attributeMapping instanceof ToOneAttributeMapping) {
                    ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)attributeMapping;
                    ForeignKeyDescriptor fkDescriptor = toOneAttributeMapping.getForeignKeyDescriptor();
                    Object identifier = fkDescriptor.getAssociationKeyFromSide(o, toOneAttributeMapping.getSideNature().inverse(), session);
                    span += fkDescriptor.forEachJdbcValue(identifier, span + offset, x, y, valuesConsumer, session);
                    continue;
                }
                span += attributeMapping.forEachJdbcValue(o, span + offset, x, y, valuesConsumer, session);
            }
        }
        return span;
    }

    @Override
    public SqlTuple toSqlExpression(TableGroup tableGroup, Clause clause, SqmToSqlAstConverter walker, SqlAstCreationState sqlAstCreationState) {
        EmbeddableMappingType selectableMappings = this.getEmbeddableTypeDescriptor();
        ArrayList columnReferences = CollectionHelper.arrayList(selectableMappings.getJdbcTypeCount());
        NavigablePath navigablePath = tableGroup.getNavigablePath().append(this.getNavigableRole().getNavigableName());
        TableReference defaultTableReference = tableGroup.resolveTableReference(navigablePath, this.getContainingTableExpression());
        this.getEmbeddableTypeDescriptor().forEachSelectable((columnIndex, selection) -> {
            TableReference tableReference = this.getContainingTableExpression().equals(selection.getContainingTableExpression()) ? defaultTableReference : tableGroup.resolveTableReference(navigablePath, selection.getContainingTableExpression());
            Expression columnReference = sqlAstCreationState.getSqlExpressionResolver().resolveSqlExpression(tableReference, selection);
            columnReferences.add((ColumnReference)columnReference);
        });
        return new SqlTuple(columnReferences, this);
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return new EmbeddableResultImpl(navigablePath, this, resultVariable, creationState);
    }

    @Override
    public Object instantiate() {
        return this.getEntityMapping().getRepresentationStrategy().getInstantiator().instantiate(this.sessionFactory);
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.entityMapping;
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this;
    }

    @Override
    public FetchStyle getStyle() {
        return FetchStyle.JOIN;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }

    protected EntityMappingType getEntityMapping() {
        return this.entityMapping;
    }

    @Override
    public boolean hasPartitionedSelectionMapping() {
        return false;
    }

    @Override
    public boolean containsTableReference(String tableExpression) {
        return this.entityMapping.containsTableReference(tableExpression);
    }
}

