/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChange;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.SetTableRemarksStatement;
import lombok.Generated;

@DatabaseChange(name="setTableRemarks", description="Set remarks on a table", priority=1)
public class SetTableRemarksChange
extends AbstractChange {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String remarks;

    @Override
    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.addAll(super.validate(database));
        return validationErrors;
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new SetTableRemarksStatement(this.catalogName, this.schemaName, this.tableName, this.remarks)};
    }

    @DatabaseChangeProperty(description="Name of the database catalog")
    public String getCatalogName() {
        return this.catalogName;
    }

    @DatabaseChangeProperty(description="Name of the database schema")
    public String getSchemaName() {
        return this.schemaName;
    }

    @DatabaseChangeProperty(description="Name of the table to set remarks on")
    public String getTableName() {
        return this.tableName;
    }

    @DatabaseChangeProperty(description="A brief descriptive comment stored in the table metadata")
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public String getConfirmationMessage() {
        return "Remarks set on " + this.tableName;
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog";
    }

    @Generated
    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
}

