/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.content.link.service;

import io.meeds.content.link.model.Link;
import io.meeds.content.link.model.LinkData;
import io.meeds.content.link.model.LinkSetting;
import io.meeds.content.link.model.LinkWithIconAttachment;
import io.meeds.content.link.model.LinkWithImageContent;
import io.meeds.content.link.storage.LinkStorage;
import io.meeds.social.cms.service.CMSService;
import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.service.TranslationService;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.upload.UploadService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LinkService {
    public static final String LINKS_CREATED_EVENT = "links.created";
    public static final String LINKS_UPDATED_EVENT = "links.updated";
    public static final String NO_ASSOCIATED_PAGE_TO_LINK = "Link setting with name '%s' doesn't have an associated page";
    public static final String PAGE_NOT_ACCESSIBLE_FOR_USER = "Page %s isn't accessible for user %s";
    public static final String PAGE_NOT_EDITABLE_BY_USER = "Page %s isn't modifiable by user %s";
    public static final String LINK_SETTING_PAGE_IS_MANDATORY = "link setting page is mandatory";
    public static final String LINK_SETTING_NAME_IS_MANDATORY = "link setting name is mandatory";
    public static final String ERROR_READING_ICON = "Error while reading link icon fir setting '%s' with id '%s'";
    public static final String FILE_API_NAMESPACE = "links";
    public static final String LINK_SETTINGS_HEADER_FIELD = "header";
    public static final String LINK_NAME_FIELD = "name";
    public static final String LINK_DESCRIPTION_FIELD = "description";
    private static final Log LOG = ExoLogger.getLogger(LinkService.class);
    @Autowired
    protected ListenerService listenerService;
    @Autowired
    protected FileService fileService;
    @Autowired
    protected UploadService uploadService;
    @Autowired
    protected TranslationService translationService;
    @Autowired
    protected LocaleConfigService localeConfigService;
    @Autowired
    protected CMSService cmsService;
    @Autowired
    protected LinkStorage linkStorage;

    public LinkSetting getLinkSettingByName(String linkSettingName, String language, Identity identity) throws IllegalAccessException {
        LinkSetting linkSetting = this.getLinkSettingByName(linkSettingName, language, true);
        if (linkSetting == null) {
            return null;
        }
        if (!this.hasAccessPermission(linkSettingName, identity)) {
            throw new IllegalAccessException(String.format(PAGE_NOT_ACCESSIBLE_FOR_USER, linkSetting.getPageReference(), identity == null ? IdentityConstants.ANONIM : identity.getUserId()));
        }
        return linkSetting;
    }

    public LinkSetting getLinkSettingByName(String linkSettingName) {
        return this.getLinkSettingByName(linkSettingName, null, false);
    }

    public LinkSetting getLinkSettingByName(String linkSettingName, String language, boolean includeTranslations) {
        LinkSetting linkSetting = this.linkStorage.getLinkSetting(linkSettingName);
        if (linkSetting != null && includeTranslations) {
            Map<String, String> header = this.getTranslations("link-settings", linkSetting.getId(), LINK_SETTINGS_HEADER_FIELD, language);
            linkSetting.setHeader(header);
        }
        return linkSetting;
    }

    public LinkSetting getLinkSettingById(long linkSettingId) {
        return this.linkStorage.getLinkSetting(linkSettingId);
    }

    public boolean hasLinkSetting(String linkSettingName) {
        return this.linkStorage.hasLinkSetting(linkSettingName);
    }

    public LinkSetting getLinkSettingByLinkId(long linkId) {
        return this.linkStorage.getLinkSettingByLinkId(linkId);
    }

    public LinkSetting initLinkSetting(String name, String pageReference, long spaceId) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException(LINK_SETTING_NAME_IS_MANDATORY);
        }
        if (StringUtils.isBlank((CharSequence)pageReference)) {
            throw new IllegalArgumentException(LINK_SETTING_PAGE_IS_MANDATORY);
        }
        LinkSetting linkSetting = this.linkStorage.initLinkSetting(name, pageReference, spaceId);
        this.broadcast(LINKS_CREATED_EVENT, null, linkSetting);
        return linkSetting;
    }

    public LinkSetting saveLinkSetting(LinkSetting linkSetting, List<Link> links, Identity identity) throws IllegalAccessException, ObjectNotFoundException {
        String linkSettingName = linkSetting.getName();
        if (this.linkStorage.getLinkSetting(linkSettingName) == null) {
            throw new ObjectNotFoundException("Link setting not found");
        }
        if (!this.hasEditPermission(linkSettingName, identity)) {
            throw new IllegalAccessException(String.format(PAGE_NOT_EDITABLE_BY_USER, this.linkStorage.getLinkSetting(linkSettingName).getPageReference(), identity == null ? IdentityConstants.ANONIM : identity.getUserId()));
        }
        LinkSetting existingLinkSetting = this.saveLinkSetting(linkSetting, links);
        existingLinkSetting.setHeader(linkSetting.getHeader());
        this.broadcast(LINKS_UPDATED_EVENT, identity.getUserId(), existingLinkSetting);
        return existingLinkSetting;
    }

    public LinkSetting saveLinkSetting(LinkSetting linkSetting, List<Link> links) throws ObjectNotFoundException {
        String linkSettingName = linkSetting.getName();
        LinkSetting existingLinkSetting = this.linkStorage.getLinkSetting(linkSettingName);
        existingLinkSetting.setType(linkSetting.getType());
        existingLinkSetting.setVAlign(linkSetting.getVAlign());
        existingLinkSetting.setHAlign(linkSetting.getHAlign());
        existingLinkSetting.setLargeIcon(linkSetting.isLargeIcon());
        existingLinkSetting.setIconSize(linkSetting.getIconSize());
        existingLinkSetting.setSeeMore(linkSetting.getSeeMore());
        existingLinkSetting.setShowName(linkSetting.isShowName());
        existingLinkSetting.setShowIcon(linkSetting.isShowIcon());
        existingLinkSetting.setShowDescription(linkSetting.isShowDescription());
        existingLinkSetting = this.linkStorage.saveLinkSetting(existingLinkSetting);
        List<Link> existingLinks = this.getLinks(linkSettingName);
        if (CollectionUtils.isEmpty(existingLinks)) {
            existingLinks = Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(links)) {
            links = Collections.emptyList();
        }
        this.processNewLinks(linkSettingName, existingLinks, links);
        this.processUpdatedLinks(linkSettingName, existingLinks, links);
        this.processDeletedLinks(linkSettingName, existingLinks, links);
        this.saveLinkTranslationLabels("link-settings", existingLinkSetting.getId(), linkSetting.getHeader(), LINK_SETTINGS_HEADER_FIELD);
        return existingLinkSetting;
    }

    public void saveLinkData(String linkSettingName, LinkData linkData) throws ObjectNotFoundException {
        LinkSetting linkSetting = linkData.getLinkSetting();
        if (linkSetting != null) {
            LinkSetting originalLinkSetting = this.getLinkSettingByName(linkSettingName);
            linkSetting.setId(originalLinkSetting.getId());
            linkSetting.setName(originalLinkSetting.getName());
            linkSetting.setLastModified(originalLinkSetting.getLastModified());
            linkSetting.setPageReference(originalLinkSetting.getPageReference());
            linkSetting.setSpaceId(originalLinkSetting.getSpaceId());
            List<LinkWithImageContent> linkWithImageContents = linkData.getLinks();
            List<Link> links = linkWithImageContents.stream().map(l -> {
                LinkWithIconAttachment linkWithIconAttachment = new LinkWithIconAttachment((Link)l);
                linkWithIconAttachment.setIconFileId(0L);
                linkWithIconAttachment.setId(0L);
                String imageContent = l.getImageContent();
                if (StringUtils.isNotBlank((CharSequence)imageContent)) {
                    try {
                        byte[] imageContentBytes = Base64.decodeBase64((String)imageContent);
                        linkWithIconAttachment.setInputStream(new ByteArrayInputStream(imageContentBytes));
                    }
                    catch (Exception e) {
                        LOG.warn("Error while creating UploadId for link {} icon", new Object[]{l.getUrl(), e});
                    }
                }
                return linkWithIconAttachment;
            }).toList();
            this.saveLinkSetting(linkSetting, links);
        }
    }

    public LinkData getLinkDataByName(String linkSettingName) throws ObjectNotFoundException {
        LinkSetting linkSetting = this.getLinkSettingByName(linkSettingName, null, true);
        if (linkSetting == null) {
            throw new ObjectNotFoundException(String.format("Link setting with name %s wasn't found", linkSettingName));
        }
        List<Link> links = this.getLinks(linkSettingName, null, true);
        return new LinkData(linkSetting, links.stream().map(this::toLinkWithImageContent).toList());
    }

    public List<Link> getLinks(String linkSettingName) {
        return this.getLinks(linkSettingName, null, false);
    }

    public List<Link> getLinks(String linkSettingName, String language, boolean includeTranslations) {
        List<Link> links = this.linkStorage.getLinks(linkSettingName);
        if (CollectionUtils.isEmpty(links)) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isNotEmpty(links) && includeTranslations) {
            for (Link link : links) {
                Map<String, String> name = this.getTranslations(FILE_API_NAMESPACE, link.getId(), LINK_NAME_FIELD, language);
                link.setName(name);
                Map<String, String> description = this.getTranslations(FILE_API_NAMESPACE, link.getId(), LINK_DESCRIPTION_FIELD, language);
                link.setDescription(description);
            }
        }
        return links;
    }

    public InputStream getLinkIconStream(String linkSettingName, long linkId) throws IOException {
        Link link;
        List<Link> links = this.getLinks(linkSettingName);
        Link link2 = link = CollectionUtils.isEmpty(links) ? null : (Link)links.stream().filter(l -> l.getId() == linkId).findFirst().orElse(null);
        if (link == null || link.getIconFileId() == 0L) {
            return null;
        }
        try {
            FileItem file = this.fileService.getFile(link.getIconFileId());
            return file == null ? null : file.getAsStream();
        }
        catch (FileStorageException e) {
            throw new IOException(String.format(ERROR_READING_ICON, linkSettingName, linkId), e);
        }
    }

    public boolean hasAccessPermission(String linkSettingName, Identity identity) {
        LinkSetting linkSetting = this.getLinkSettingByName(linkSettingName);
        if (linkSetting == null || StringUtils.isBlank((CharSequence)linkSetting.getPageReference())) {
            return false;
        }
        return this.cmsService.hasAccessPermission(identity, linkSetting.getPageReference(), linkSetting.getSpaceId());
    }

    public boolean hasEditPermission(String linkSettingName, Identity identity) {
        LinkSetting linkSetting = this.getLinkSettingByName(linkSettingName);
        if (linkSetting == null || StringUtils.isBlank((CharSequence)linkSetting.getPageReference())) {
            return false;
        }
        return this.cmsService.hasEditPermission(identity, linkSetting.getPageReference(), linkSetting.getSpaceId());
    }

    private void processNewLinks(String linkSettingName, List<Link> existingLinks, List<Link> links) {
        links.stream().filter(l -> l.getId() == 0L).forEach(link -> {
            this.processLinkIcon((Link)link, existingLinks);
            Link createdLink = this.linkStorage.createLink(linkSettingName, (Link)link);
            try {
                this.saveLinkTranslationLabels(FILE_API_NAMESPACE, createdLink.getId(), link.getName(), LINK_NAME_FIELD);
                this.saveLinkTranslationLabels(FILE_API_NAMESPACE, createdLink.getId(), link.getDescription(), LINK_DESCRIPTION_FIELD);
            }
            catch (ObjectNotFoundException e) {
                throw new IllegalStateException("Error setting translation of newly created link " + createdLink.getId(), e);
            }
        });
    }

    private void processUpdatedLinks(String linkSettingName, List<Link> existingLinks, List<Link> links) {
        links.stream().filter(l -> existingLinks.stream().anyMatch(l2 -> l.getId() == l2.getId())).forEach(link -> {
            this.processLinkIcon((Link)link, existingLinks);
            Link updatedLink = this.linkStorage.updateLink(linkSettingName, (Link)link);
            try {
                this.saveLinkTranslationLabels(FILE_API_NAMESPACE, updatedLink.getId(), link.getName(), LINK_NAME_FIELD);
                this.saveLinkTranslationLabels(FILE_API_NAMESPACE, updatedLink.getId(), link.getDescription(), LINK_DESCRIPTION_FIELD);
            }
            catch (ObjectNotFoundException e) {
                throw new IllegalStateException("Error setting translation of updated link " + updatedLink.getId(), e);
            }
        });
    }

    private void processDeletedLinks(String linkSettingName, List<Link> existingLinks, List<Link> links) {
        existingLinks.stream().filter(l -> links.stream().noneMatch(l2 -> l.getId() == l2.getId())).forEach(link -> {
            this.deleteLinkIconFile(link.getIconFileId());
            try {
                this.translationService.deleteTranslationLabels(FILE_API_NAMESPACE, link.getId());
            }
            catch (ObjectNotFoundException e) {
                throw new IllegalStateException("Error setting translation of deleted link " + link.getId(), e);
            }
            finally {
                this.linkStorage.deleteLink(linkSettingName, link.getId());
            }
        });
    }

    private void processLinkIcon(Link link, List<Link> existingLinks) {
        LinkWithIconAttachment linkWithIconAttachment;
        long oldFileId = existingLinks.stream().filter(l -> l.getId() == link.getId()).map(Link::getIconFileId).findFirst().orElse(0L);
        if (link instanceof LinkWithIconAttachment && (StringUtils.isNotBlank((CharSequence)(linkWithIconAttachment = (LinkWithIconAttachment)link).getUploadId()) || linkWithIconAttachment.getInputStream() != null)) {
            try (InputStream inputStream = this.getInputStream(linkWithIconAttachment);){
                FileItem fileItem = new FileItem(null, "icon.png", "image/png", FILE_API_NAMESPACE, (long)inputStream.available(), new Date(), IdentityConstants.SYSTEM, false, inputStream);
                fileItem = this.fileService.writeFile(fileItem);
                link.setIconFileId(fileItem.getFileInfo().getId());
                if (oldFileId > 0L) {
                    this.deleteLinkIconFile(oldFileId);
                }
            }
            catch (Exception e) {
                LOG.warn("Error while writing link {} icon file", new Object[]{link.getUrl(), e});
            }
        } else if (oldFileId > 0L && link.getIconFileId() == 0L) {
            this.deleteLinkIconFile(oldFileId);
        } else {
            link.setIconFileId(oldFileId);
        }
    }

    private InputStream getInputStream(LinkWithIconAttachment linkWithIconAttachment) throws FileNotFoundException {
        return linkWithIconAttachment.getInputStream() == null ? new FileInputStream(this.uploadService.getUploadResource(linkWithIconAttachment.getUploadId()).getStoreLocation()) : linkWithIconAttachment.getInputStream();
    }

    private void deleteLinkIconFile(long oldFileId) {
        this.fileService.deleteFile(oldFileId);
    }

    private void saveLinkTranslationLabels(String type, long id, Map<String, String> values, String fieldName) throws ObjectNotFoundException {
        if (MapUtils.isEmpty(values)) {
            this.translationService.saveTranslationLabels(type, id, fieldName, Collections.singletonMap(this.localeConfigService.getDefaultLocaleConfig().getLocale(), ""));
        } else {
            this.translationService.saveTranslationLabels(type, id, fieldName, values.entrySet().stream().collect(Collectors.toMap(e -> Locale.forLanguageTag((String)e.getKey()), Map.Entry::getValue)));
        }
    }

    private Map<String, String> getTranslations(String objectType, long objectId, String fieldName, String language) {
        if (StringUtils.isBlank((CharSequence)language)) {
            TranslationField translationField;
            try {
                translationField = this.translationService.getTranslationField(objectType, objectId, fieldName);
            }
            catch (ObjectNotFoundException e) {
                translationField = null;
            }
            return this.toTranslations(translationField, "");
        }
        String label = this.translationService.getTranslationLabel(objectType, objectId, fieldName, Locale.forLanguageTag(language));
        if (StringUtils.isBlank((CharSequence)label)) {
            String defaultLanguage = this.localeConfigService.getDefaultLocaleConfig().getLocale().toLanguageTag();
            if (StringUtils.equals((CharSequence)defaultLanguage, (CharSequence)language)) {
                if (!Locale.ENGLISH.toLanguageTag().equals(language)) {
                    label = this.translationService.getTranslationLabel(objectType, objectId, fieldName, Locale.ENGLISH);
                }
                return Collections.singletonMap(Locale.ENGLISH.toLanguageTag(), !StringUtils.isBlank((CharSequence)label) ? label : "");
            }
            return Collections.singletonMap(language, this.getTranslations(objectType, objectId, fieldName, defaultLanguage).get(defaultLanguage));
        }
        return Collections.singletonMap(language, label);
    }

    private Map<String, String> toTranslations(TranslationField translationField, String defaultValue) {
        boolean hasTranslation = translationField == null || MapUtils.isEmpty((Map)translationField.getLabels());
        return hasTranslation ? Collections.singletonMap(this.localeConfigService.getDefaultLocaleConfig().getLocale().toLanguageTag(), defaultValue) : translationField.getLabels().entrySet().stream().collect(Collectors.toMap(e -> ((Locale)e.getKey()).toLanguageTag(), Map.Entry::getValue));
    }

    private void broadcast(String eventName, Object source, Object data) {
        try {
            this.listenerService.broadcast(eventName, source, data);
        }
        catch (Exception e) {
            LOG.warn("Error while broadcasting event '{}' for object {}", new Object[]{eventName, data, e});
        }
    }

    private LinkWithImageContent toLinkWithImageContent(Link link) {
        LinkWithImageContent linkWithImageContent = new LinkWithImageContent(link);
        long fileId = linkWithImageContent.getIconFileId();
        if (fileId > 0L) {
            FileItem fileItem = this.fileService.getFile(fileId);
            linkWithImageContent.setImageContent(Base64.encodeBase64String((byte[])fileItem.getAsByte()));
        }
        return linkWithImageContent;
    }
}

