/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.container;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;

public abstract class UIComponentFactory<T extends UIComponent> {
    protected static final Map<Class<?>, List<UIComponentFactory<?>>> COMPONENT_FACTORY = new HashMap();

    public static <T extends UIComponent> UIComponentFactory<? extends T> getInstance(Class<T> type) {
        if (type == null) {
            throw new NullPointerException(String.valueOf(type) + " is null");
        }
        final LinkedList list = new LinkedList();
        for (Class<?> t : COMPONENT_FACTORY.keySet()) {
            if (!type.isAssignableFrom(t)) continue;
            for (UIComponentFactory<?> factory : COMPONENT_FACTORY.get(t)) {
                list.add(factory);
            }
        }
        return new UIComponentFactory<T>(){

            @Override
            public T createUIComponent(String factoryID, WebuiRequestContext context) {
                UIComponentFactory f;
                Object uiComponent = null;
                Iterator iterator = list.iterator();
                while (iterator.hasNext() && (uiComponent = (Object)(f = (UIComponentFactory)iterator.next()).createUIComponent(factoryID, context)) == null) {
                }
                return uiComponent;
            }
        };
    }

    protected T create(Class<? extends T> type, WebuiRequestContext context) {
        try {
            if (context == null) {
                return (T)((UIComponent)type.newInstance());
            }
            WebuiApplication app = (WebuiApplication)context.getApplication();
            return app.createUIComponent(type, null, null, context);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public T createUIComponent(String factoryID) {
        return this.createUIComponent(factoryID, (WebuiRequestContext)WebuiRequestContext.getCurrentInstance());
    }

    public abstract T createUIComponent(String var1, WebuiRequestContext var2);

    static {
        ServiceLoader<UIComponentFactory> loader = ServiceLoader.load(UIComponentFactory.class);
        for (UIComponentFactory factory : loader) {
            Type genericSuper = factory.getClass().getGenericSuperclass();
            Class supportedType = UIComponent.class;
            if (genericSuper instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)genericSuper;
                supportedType = (Class)parameterizedType.getActualTypeArguments()[0];
            }
            COMPONENT_FACTORY.computeIfAbsent(supportedType, k -> new LinkedList()).add(factory);
        }
    }
}

