/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.plugin;

import io.meeds.portal.plugin.AclPlugin;
import jakarta.annotation.PostConstruct;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpaceAclPlugin
implements AclPlugin {
    public static final String OBJECT_TYPE = "space";
    public static final String LIST_PERMISSION_TYPE = "list";
    public static final String LAYOUT_PERMISSION_TYPE = "layout";
    public static final String PUBLISH_PERMISSION_TYPE = "publish";
    public static final String REDACT_PERMISSION_TYPE = "redact";
    public static final String MANAGE_PERMISSION_TYPE = "manage";
    @Autowired
    private PortalContainer container;
    @Autowired
    private SpaceService spaceService;

    @PostConstruct
    public void init() {
        ((UserACL)this.container.getComponentInstanceOfType(UserACL.class)).addAclPlugin((AclPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean hasPermission(String objectId, String permissionType, Identity identity) {
        Space space = this.spaceService.getSpaceById(Long.parseLong(objectId));
        if (space == null) {
            return false;
        }
        String username = identity == null ? null : identity.getUserId();
        return switch (permissionType) {
            case "VIEW" -> this.spaceService.canViewSpace(space, username);
            case MANAGE_PERMISSION_TYPE, "EDIT" -> {
                if (identity != null && this.spaceService.canManageSpace(space, username)) {
                    yield true;
                }
                yield false;
            }
            case "DELETE" -> this.spaceService.canDeleteSpace(space, username);
            case LIST_PERMISSION_TYPE -> this.spaceService.canViewSpace(space, username);
            case REDACT_PERMISSION_TYPE -> this.spaceService.canRedactOnSpace(space, username);
            case PUBLISH_PERMISSION_TYPE -> this.spaceService.canPublishOnSpace(space, username);
            case LAYOUT_PERMISSION_TYPE -> this.spaceService.canManageSpaceLayout(space, username);
            default -> false;
        };
    }
}

