/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.storage.impl;

import io.meeds.task.domain.LabelField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.domain.Label;
import org.exoplatform.task.dto.LabelDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.storage.LabelStorage;
import org.exoplatform.task.storage.ProjectStorage;
import org.exoplatform.task.util.StorageUtil;

public class LabelStorageImpl
implements LabelStorage {
    private static final Log LOG = ExoLogger.getExoLogger(LabelStorageImpl.class);
    private static final Pattern pattern = Pattern.compile("@([^\\s]+)|@([^\\s]+)$");
    @Inject
    private final DAOHandler daoHandler;

    public LabelStorageImpl(DAOHandler daoHandler) {
        this.daoHandler = daoHandler;
    }

    @Override
    public List<LabelDto> findLabelsByUser(String username, int offset, int limit) {
        try {
            return Arrays.asList((Label[])this.daoHandler.getLabelHandler().findLabelsByUser(username).load(offset, limit)).stream().map(StorageUtil::labelToDto).collect(Collectors.toList());
        }
        catch (Exception e) {
            return new ArrayList<LabelDto>();
        }
    }

    @Override
    public List<LabelDto> findLabelsByProject(long projectId, Identity currentUser, ProjectStorage projectStorage, int offset, int limit) {
        try {
            return Arrays.asList((Label[])this.daoHandler.getLabelHandler().findLabelsByProject(projectId).load(offset, limit)).stream().map(label -> StorageUtil.labelToDto(label, currentUser, projectStorage)).collect(Collectors.toList());
        }
        catch (Exception e) {
            return new ArrayList<LabelDto>();
        }
    }

    @Override
    public List<LabelDto> findLabelsByTask(TaskDto task, long projectId, Identity currentUser, ProjectStorage projectStorage, int offset, int limit) {
        try {
            return Arrays.asList((Label[])this.daoHandler.getLabelHandler().findLabelsByTask(task.getId(), projectId).load(offset, limit)).stream().map(label -> StorageUtil.labelToDto(label, task, currentUser, projectStorage)).collect(Collectors.toList());
        }
        catch (Exception e) {
            return new ArrayList<LabelDto>();
        }
    }

    @Override
    public LabelDto getLabel(long labelId) {
        return StorageUtil.labelToDto((Label)this.daoHandler.getLabelHandler().find(Long.valueOf(labelId)));
    }

    @Override
    public LabelDto createLabel(LabelDto label) {
        return StorageUtil.labelToDto((Label)this.daoHandler.getLabelHandler().create(StorageUtil.labelToEntity(label)));
    }

    @Override
    public LabelDto updateLabel(LabelDto label, List<LabelField> fields) throws EntityNotFoundException {
        return null;
    }

    @Override
    public void removeLabel(long labelId) {
        this.daoHandler.getLabelHandler().delete(StorageUtil.labelToEntity(this.getLabel(labelId)));
    }

    @Override
    public void addTaskToLabel(TaskDto task, Long labelId) throws EntityNotFoundException {
    }

    @Override
    public void removeTaskFromLabel(TaskDto task, Long labelId) throws EntityNotFoundException {
    }
}

