/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache.model.data;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.storage.cache.model.data.CacheData;
import org.exoplatform.social.core.storage.cache.model.data.IdentityData;

public class RelationshipData
implements CacheData<Relationship> {
    private static final long serialVersionUID = -4556401100496633230L;
    private final String id;
    private final IdentityData sender;
    private final IdentityData receiver;
    private final Relationship.Type type;

    public RelationshipData(Relationship relationship) {
        this.id = relationship.getId();
        this.sender = new IdentityData(relationship.getSender());
        this.receiver = new IdentityData(relationship.getReceiver());
        this.type = relationship.getStatus();
    }

    public Relationship.Type getType() {
        return this.type;
    }

    @Override
    public Relationship build() {
        Relationship relationship = new Relationship(this.sender.build(), this.receiver.build(), this.type);
        relationship.setId(this.id);
        return relationship;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RelationshipData)) {
            return false;
        }
        RelationshipData that = (RelationshipData)o;
        if (this.sender != null ? !this.sender.equals(that.sender) : that.sender != null) {
            return false;
        }
        if (this.receiver != null ? !this.receiver.equals(that.receiver) : that.receiver != null) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.id, (CharSequence)that.id) && this.type == that.type;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.sender != null ? this.sender.hashCode() : 0);
        result = 31 * result + (this.receiver != null ? this.receiver.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }
}

