/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.storage.impl;

import jakarta.persistence.NonUniqueResultException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.dao.StatusHandler;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.dto.StatusDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.exception.NotAllowedOperationOnEntityException;
import org.exoplatform.task.storage.ProjectStorage;
import org.exoplatform.task.storage.StatusStorage;
import org.exoplatform.task.storage.TaskStorage;
import org.exoplatform.task.util.StorageUtil;

public class StatusStorageImpl
implements StatusStorage {
    private static final Log LOG = ExoLogger.getExoLogger(StatusStorageImpl.class);
    @Inject
    private final DAOHandler daoHandler;
    @Inject
    private final ProjectStorage projectStorage;
    private final TaskStorage taskStorage;

    public StatusStorageImpl(DAOHandler daoHandler, TaskStorage taskStorage, ProjectStorage projectStorage) {
        this.daoHandler = daoHandler;
        this.projectStorage = projectStorage;
        this.taskStorage = taskStorage;
    }

    @Override
    public StatusDto getStatus(long statusId) {
        return StorageUtil.statusToDTO((Status)this.daoHandler.getStatusHandler().find(Long.valueOf(statusId)), this.projectStorage);
    }

    @Override
    public StatusDto getDefaultStatus(long projectId) {
        Status status = null;
        try {
            status = this.daoHandler.getStatusHandler().findLowestRankStatusByProject(projectId);
        }
        catch (NonUniqueResultException e) {
            List<Status> projectStatuses = this.daoHandler.getStatusHandler().getStatuses(projectId);
            projectStatuses = projectStatuses.stream().sorted(Comparator.comparing(Status::getId).reversed()).sorted(Comparator.comparingInt(Status::getRank)).collect(Collectors.toList());
            for (int i = 0; i < projectStatuses.size(); ++i) {
                projectStatuses.get(i).setRank(i);
            }
            this.daoHandler.getStatusHandler().updateAll(projectStatuses);
            status = projectStatuses.get(0);
        }
        return StorageUtil.statusToDTO(status, this.projectStorage);
    }

    @Override
    public List<StatusDto> getStatuses(long projectId) {
        List<Status> projectStatuses = this.daoHandler.getStatusHandler().getStatuses(projectId);
        HashSet set = new HashSet();
        if (!projectStatuses.stream().allMatch(t -> set.add(t.getRank()))) {
            projectStatuses = projectStatuses.stream().sorted(Comparator.comparing(Status::getId).reversed()).sorted(Comparator.comparingInt(Status::getRank)).collect(Collectors.toList());
            for (int i = 0; i < projectStatuses.size(); ++i) {
                projectStatuses.get(i).setRank(i);
            }
            this.daoHandler.getStatusHandler().updateAll(projectStatuses);
        }
        return projectStatuses.stream().map(status -> StorageUtil.statusToDTO(status, this.projectStorage)).collect(Collectors.toList());
    }

    @Override
    public StatusDto createStatus(ProjectDto project, String status) {
        StatusDto max;
        List<StatusDto> statuses = this.getStatuses(project.getId());
        if (statuses != null) {
            for (StatusDto st : statuses) {
                if (!st.getName().equalsIgnoreCase(status)) continue;
                LOG.warn("Status {} has already exists", new Object[]{status});
                return st;
            }
        }
        int maxRank = (max = StorageUtil.statusToDTO(this.daoHandler.getStatusHandler().findHighestRankStatusByProject(project.getId()), this.projectStorage)) != null && max.getRank() != null ? max.getRank() : -1;
        StatusHandler handler = this.daoHandler.getStatusHandler();
        Status st = new Status(status, ++maxRank, project == null ? null : StorageUtil.getProjectEntityById(project.getId()));
        handler.create(st);
        return StorageUtil.statusToDTO(st, this.projectStorage);
    }

    @Override
    public StatusDto createStatus(ProjectDto project, String status, int rank) throws NotAllowedOperationOnEntityException {
        Serializable st2;
        List<StatusDto> statuses = this.getStatuses(project.getId());
        if (statuses != null) {
            for (Serializable st2 : statuses) {
                if (!st2.getName().equalsIgnoreCase(status)) continue;
                LOG.warn("Status {} has already exists", new Object[]{status});
                throw new NotAllowedOperationOnEntityException(0L, Status.class, "duplicate status name");
            }
        }
        StatusHandler handler = this.daoHandler.getStatusHandler();
        st2 = new Status(status, rank, project == null ? null : StorageUtil.getProjectEntityById(project.getId()));
        handler.create(st2);
        return StorageUtil.statusToDTO((Status)st2, this.projectStorage);
    }

    @Override
    public void removeStatus(long statusId, boolean removeAll) throws Exception {
        Status st = (Status)this.daoHandler.getStatusHandler().find(Long.valueOf(statusId));
        if (st == null) {
            throw new EntityNotFoundException(statusId, (Class<?>)Status.class);
        }
        List<Task> tasks = this.daoHandler.getTaskHandler().getByStatus(statusId);
        if (removeAll) {
            tasks.forEach(task -> this.taskStorage.delete(this.taskStorage.getTaskById(task.getId())));
        } else {
            Project project = st.getProject();
            Status altStatus = this.findAltStatus(st, project);
            if (altStatus == null) {
                throw new NotAllowedOperationOnEntityException(statusId, Status.class, "Delete last status");
            }
            for (Task task2 : tasks) {
                task2.setStatus(altStatus);
            }
            this.daoHandler.getTaskHandler().updateAll(tasks);
        }
        this.daoHandler.getStatusHandler().delete(st);
    }

    @Override
    public StatusDto updateStatus(long statusId, String statusName) throws EntityNotFoundException, NotAllowedOperationOnEntityException {
        StatusHandler handler = this.daoHandler.getStatusHandler();
        StatusDto status = StorageUtil.statusToDTO((Status)handler.find(Long.valueOf(statusId)), this.projectStorage);
        if (status == null) {
            throw new EntityNotFoundException(statusId, (Class<?>)Status.class);
        }
        List<Status> peojectStatus = handler.getStatuses(status.getProject().getId());
        for (Status st : peojectStatus) {
            if (!st.getName().equals(statusName) || st.getId() == statusId) continue;
            throw new NotAllowedOperationOnEntityException(status.getId(), Status.class, "duplicate status name");
        }
        status.setName(statusName);
        return StorageUtil.statusToDTO((Status)this.daoHandler.getStatusHandler().update(StorageUtil.statusToEntity(status)), this.projectStorage);
    }

    @Override
    public StatusDto updateStatus(StatusDto statusDto) throws EntityNotFoundException, NotAllowedOperationOnEntityException {
        StatusHandler handler = this.daoHandler.getStatusHandler();
        StatusDto status = StorageUtil.statusToDTO((Status)handler.find(statusDto.getId()), this.projectStorage);
        if (status == null) {
            throw new EntityNotFoundException((long)statusDto.getId(), (Class<?>)Status.class);
        }
        List<Status> peojectStatus = handler.getStatuses(status.getProject().getId());
        for (Status st : peojectStatus) {
            if (!st.getName().equals(statusDto.getName()) || st.getId() == status.getId().longValue()) continue;
            throw new NotAllowedOperationOnEntityException(status.getId(), Status.class, "duplicate status name");
        }
        return StorageUtil.statusToDTO((Status)this.daoHandler.getStatusHandler().update(StorageUtil.statusToEntity(statusDto)), this.projectStorage);
    }

    private Status findAltStatus(Status st, Project project) {
        LinkedList<Status> allSt = new LinkedList<Status>(this.daoHandler.getStatusHandler().getStatuses(project.getId()));
        Collections.sort(allSt);
        Status other = null;
        for (int i = 0; i < allSt.size(); ++i) {
            if (!((Status)allSt.get(i)).equals(st)) continue;
            if (i > 0) {
                other = (Status)allSt.get(i - 1);
                break;
            }
            if (i + 1 >= allSt.size()) break;
            other = (Status)allSt.get(i + 1);
            break;
        }
        return other;
    }
}

