/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ElementSubsequent;
import com.github.sommeri.less4j.core.ast.FixedNamePart;
import com.github.sommeri.less4j.core.ast.InterpolableName;
import com.github.sommeri.less4j.core.ast.SelectorCombinator;
import com.github.sommeri.less4j.core.ast.SelectorPart;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class SimpleSelector
extends SelectorPart
implements Cloneable {
    private InterpolableName elementName;
    private boolean isStar;
    private boolean isEmptyForm = false;
    private List<ElementSubsequent> subsequent = new ArrayList<ElementSubsequent>();

    public SimpleSelector(HiddenTokenAwareTree token, SelectorCombinator leadingCombinator, InterpolableName elementName, boolean isStar) {
        super(token, leadingCombinator);
        this.elementName = elementName;
        this.isStar = isStar;
    }

    @Override
    public boolean isEmpty() {
        if (this.hasSubsequent()) {
            return false;
        }
        return (!this.isStar() || this.isEmptyForm()) && !this.hasElement();
    }

    @Override
    public boolean isClassesAndIdsOnlySelector() {
        return this.isLimitedPurposeSelector(ASTCssNodeType.CSS_CLASS, ASTCssNodeType.ID_SELECTOR);
    }

    private boolean isLimitedPurposeSelector(ASTCssNodeType ... purposes) {
        if (this.elementName != null || !this.isEmptyForm() || this.subsequent == null) {
            return false;
        }
        HashSet<ASTCssNodeType> purposesSet = new HashSet<ASTCssNodeType>(Arrays.asList(purposes));
        for (ElementSubsequent es : this.subsequent) {
            if (!purposesSet.contains((Object)es.getType())) {
                return false;
            }
            if (!es.isInterpolated()) continue;
            return false;
        }
        return true;
    }

    @Override
    public InterpolableName getElementName() {
        return this.elementName;
    }

    public boolean isStar() {
        return this.isStar;
    }

    public boolean isEmptyForm() {
        return this.isEmptyForm;
    }

    public void setEmptyForm(boolean isEmptyForm) {
        this.isEmptyForm = isEmptyForm;
    }

    public void setElementName(InterpolableName elementName) {
        this.elementName = elementName;
    }

    public void setStar(boolean isStar) {
        this.isStar = isStar;
    }

    @Override
    public boolean hasElement() {
        return null != this.getElementName();
    }

    @Override
    public List<ElementSubsequent> getSubsequent() {
        return this.subsequent;
    }

    public void addSubsequent(ElementSubsequent subsequent) {
        this.subsequent.add(subsequent);
    }

    @Override
    public void removeSubsequent(ElementSubsequent subsequent) {
        this.subsequent.remove(subsequent);
    }

    @Override
    public void addSubsequent(List<ElementSubsequent> subsequent) {
        this.subsequent.addAll(subsequent);
    }

    @Override
    @NotAstProperty
    public List<ASTCssNode> getChilds() {
        List<ASTCssNode> result = super.getChilds();
        ArraysUtils.addIfNonNull(result, this.elementName);
        result.addAll(this.subsequent);
        return result;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.SIMPLE_SELECTOR;
    }

    @Override
    public SimpleSelector clone() {
        SimpleSelector clone = (SimpleSelector)super.clone();
        clone.subsequent = ArraysUtils.deeplyClonedList(this.getSubsequent());
        clone.elementName = this.elementName == null ? null : this.elementName.clone();
        clone.configureParentToAllChilds();
        return clone;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.isStar ? "*" : this.getElementName());
        builder.append(this.subsequent);
        return builder.toString();
    }

    @Override
    public void extendName(String extension, HiddenTokenAwareTree underlyingStructureOfExtension) {
        if (this.isStar) {
            this.isStar = false;
        }
        if (this.hasElement()) {
            this.getElementName().extendName(extension);
        } else {
            this.setElementName(new InterpolableName(underlyingStructureOfExtension, new FixedNamePart(this.getUnderlyingStructure(), extension)));
        }
    }
}

