/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.mvc;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.hateoas.Affordance;
import org.springframework.hateoas.TemplateVariables;
import org.springframework.hateoas.server.core.DummyInvocationUtils;
import org.springframework.hateoas.server.core.SpringAffordanceBuilder;
import org.springframework.hateoas.server.core.TemplateVariableAwareLinkBuilderSupport;
import org.springframework.hateoas.server.mvc.UriComponentsBuilderFactory;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilderFactory;
import org.springframework.util.Assert;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class WebMvcLinkBuilder
extends TemplateVariableAwareLinkBuilderSupport<WebMvcLinkBuilder> {
    private static final WebMvcLinkBuilderFactory FACTORY = new WebMvcLinkBuilderFactory();
    private static final DefaultUriBuilderFactory URI_FACTORY = new DefaultUriBuilderFactory();

    WebMvcLinkBuilder(UriComponents components) {
        this(components, TemplateVariables.NONE, Collections.emptyList());
    }

    WebMvcLinkBuilder(UriComponents uriComponents, TemplateVariables variables, List<Affordance> affordances) {
        super(uriComponents, variables, affordances);
    }

    public static WebMvcLinkBuilder linkTo(Class<?> controller) {
        return WebMvcLinkBuilder.linkTo(controller, new Object[0]);
    }

    public static WebMvcLinkBuilder linkTo(Class<?> controller, Object ... parameters) {
        Assert.notNull(controller, (String)"Controller must not be null!");
        Assert.notNull((Object)parameters, (String)"Parameters must not be null!");
        String mapping = SpringAffordanceBuilder.DISCOVERER.getMapping(controller);
        String defaulted = mapping == null ? "/" : mapping;
        URI uri = URI_FACTORY.expand(defaulted, parameters);
        UriComponents uriComponents = UriComponentsBuilder.fromUri((URI)uri).build();
        return (WebMvcLinkBuilder)new WebMvcLinkBuilder(UriComponentsBuilderFactory.getComponents()).slash(uriComponents, true);
    }

    public static WebMvcLinkBuilder linkTo(Class<?> controller, Map<String, ?> parameters) {
        Assert.notNull(controller, (String)"Controller must not be null!");
        Assert.notNull(parameters, (String)"Parameters must not be null!");
        String mapping = SpringAffordanceBuilder.DISCOVERER.getMapping(controller);
        String defaulted = mapping == null ? "/" : mapping;
        URI uri = URI_FACTORY.expand(defaulted, parameters);
        UriComponents uriComponents = UriComponentsBuilder.fromUri((URI)uri).build();
        return (WebMvcLinkBuilder)new WebMvcLinkBuilder(UriComponentsBuilderFactory.getComponents()).slash(uriComponents, true);
    }

    public static WebMvcLinkBuilder linkTo(Method method) {
        Assert.notNull((Object)method, (String)"Method must not be null!");
        return WebMvcLinkBuilder.linkTo(method.getDeclaringClass(), method, new Object[method.getParameterTypes().length]);
    }

    public static WebMvcLinkBuilder linkTo(Method method, Object ... parameters) {
        Assert.notNull((Object)method, (String)"Method must not be null!");
        Assert.notNull((Object)parameters, (String)"Parameters must not be null!");
        return WebMvcLinkBuilder.linkTo(method.getDeclaringClass(), method, parameters);
    }

    public static WebMvcLinkBuilder linkTo(Class<?> controller, Method method) {
        Assert.notNull(controller, (String)"Controller type must not be null!");
        Assert.notNull((Object)method, (String)"Method must not be null!");
        return WebMvcLinkBuilder.linkTo(controller, method, new Object[method.getParameterTypes().length]);
    }

    public static WebMvcLinkBuilder linkTo(Class<?> controller, Method method, Object ... parameters) {
        Assert.notNull(controller, (String)"Controller type must not be null!");
        Assert.notNull((Object)method, (String)"Method must not be null!");
        Assert.notNull((Object)parameters, (String)"Parameters must not be null!");
        int expected = method.getParameterTypes().length;
        int given = parameters.length;
        Assert.isTrue((expected == given ? 1 : 0) != 0, () -> String.format("Incorrect number of parameter values given. Expected %s, got %s!", expected, given));
        return WebMvcLinkBuilder.linkTo(DummyInvocationUtils.getLastInvocationAware(controller, method, parameters));
    }

    public static WebMvcLinkBuilder linkTo(Object invocationValue) {
        return FACTORY.linkTo(invocationValue);
    }

    public static Affordance afford(Object invocationValue) {
        WebMvcLinkBuilder linkBuilder = WebMvcLinkBuilder.linkTo(invocationValue);
        Assert.isTrue((linkBuilder.getAffordances().size() == 1 ? 1 : 0) != 0, (String)"A base can only have one affordance, itself");
        return linkBuilder.getAffordances().get(0);
    }

    public static <T> T methodOn(Class<T> controller, Object ... parameters) {
        return DummyInvocationUtils.methodOn(controller, parameters);
    }

    @Override
    protected WebMvcLinkBuilder getThis() {
        return this;
    }

    @Override
    protected WebMvcLinkBuilder createNewInstance(UriComponents components, List<Affordance> affordances, TemplateVariables variables) {
        return new WebMvcLinkBuilder(components, variables, affordances);
    }

    public UriComponentsBuilder toUriComponentsBuilder() {
        return UriComponentsBuilder.fromUri((URI)this.toUri());
    }
}

