/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.common.i18n;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.gatein.api.internal.ObjectToStringBuilder;
import org.gatein.api.internal.Parameters;

public abstract class Localized<T extends Serializable>
implements Iterable<T>,
Serializable {
    private final Map<Locale, Value<T>> values;

    protected Localized(Localized<T> localized) {
        this.values = new HashMap<Locale, Value<T>>(localized.values);
    }

    protected Localized(Locale locale, T value) {
        this(Collections.singletonMap(locale, value));
    }

    protected Localized(Map<Locale, T> valueMap) {
        Parameters.requireNonNull(valueMap, "valueMap");
        HashMap<Locale, Value<T>> map = new HashMap<Locale, Value<T>>(valueMap.size());
        for (Map.Entry<Locale, T> entry : valueMap.entrySet()) {
            Locale locale = entry.getKey();
            Serializable value = (Serializable)entry.getValue();
            if (value == null) {
                throw new IllegalArgumentException("valueMap contains a null value for key locale " + locale);
            }
            map.put(locale, new Value(locale, value, null));
        }
        this.values = map;
    }

    public Value<T> getLocalizedValue(Locale locale) {
        return this.values.get(locale);
    }

    public T getValue(Locale locale) {
        Value<T> value = this.getLocalizedValue(locale);
        return value == null ? null : (T)value.getValue();
    }

    public Localized<T> setLocalizedValue(Locale locale, T value) {
        this.values.put(locale, new Value(locale, (Serializable)value, null));
        return this;
    }

    public void removeLocalizedValue(Locale locale) {
        this.values.remove(locale);
    }

    public Collection<Value<T>> getLocalizedValues() {
        return Collections.unmodifiableCollection(this.values.values());
    }

    @Override
    public Iterator<T> iterator() {
        ArrayList<T> list = new ArrayList<T>(this.values.size());
        for (Value<T> value : this.values.values()) {
            list.add(value.getValue());
        }
        return list.iterator();
    }

    public String toString() {
        return ObjectToStringBuilder.toStringBuilder(this.getClass()).add("values", this.values.values()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Localized)) {
            return false;
        }
        Localized localized = (Localized)o;
        return this.values.equals(localized.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    static class 1 {
    }

    public static final class Value<T extends Serializable>
    implements Serializable {
        private final Locale locale;
        private final T value;

        private Value(Locale locale, T value) {
            this.locale = locale;
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Value v = (Value)o;
            return this.locale == null ? v.locale == null : (this.locale.equals(v.locale) && this.value == null ? v.value == null : this.value.equals(v.value));
        }

        public int hashCode() {
            int result = this.locale != null ? this.locale.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return ObjectToStringBuilder.toStringBuilder(this.getClass()).add("locale", this.locale).add("value", this.value).toString();
        }

        /* synthetic */ Value(Locale x0, Serializable x1, 1 x2) {
            this(x0, x1);
        }
    }
}

