/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.content.news.search;

import io.meeds.content.news.model.News;
import io.meeds.content.news.service.NewsService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.search.DocumentWithMetadata;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.wiki.utils.Utils;

public class NewsIndexingServiceConnector
extends ElasticIndexingServiceConnector {
    public static final String TYPE = "news";
    private static final Log LOG = ExoLogger.getLogger(NewsIndexingServiceConnector.class);
    private final NewsService newsService;
    private final IdentityManager identityManager;
    private final ActivityManager activityManager;
    private final MetadataService metadataService;

    public NewsIndexingServiceConnector(IdentityManager identityManager, InitParams initParams, NewsService newsService, ActivityManager activityManager, MetadataService metadataService) {
        super(initParams);
        this.newsService = newsService;
        this.identityManager = identityManager;
        this.activityManager = activityManager;
        this.metadataService = metadataService;
    }

    public String getConnectorName() {
        return TYPE;
    }

    public Document create(String id) {
        return this.getDocument(id);
    }

    public Document update(String id) {
        return this.getDocument(id);
    }

    public List<String> getAllIds(int offset, int limit) {
        throw new UnsupportedOperationException();
    }

    private Document getDocument(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("id is mandatory");
        }
        LOG.debug("Index document for news id={}", new Object[]{id});
        News news = null;
        String newsId = null;
        String lang = null;
        try {
            if (StringUtils.contains((CharSequence)id, (CharSequence)"-")) {
                newsId = StringUtils.substringBefore((String)id, (String)"-");
                lang = StringUtils.substringAfter((String)id, (String)"-");
            }
            news = newsId != null ? this.newsService.getNewsArticleByIdAndLang(newsId, lang) : this.newsService.getNewsArticleById(id);
        }
        catch (Exception e) {
            LOG.error((Object)("Error when getting the news " + id), (Throwable)e);
        }
        if (news == null) {
            throw new IllegalStateException("news with id '" + id + "' is mandatory");
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("id", news.getId());
        fields.put("title", news.getTitle());
        String body = news.getBody();
        String summary = "";
        if (news.getProperties() != null) {
            summary = news.getProperties().getSummary();
        }
        if (StringUtils.isBlank((CharSequence)body)) {
            body = news.getTitle();
        }
        if (StringUtils.isNotBlank((CharSequence)body)) {
            body = StringEscapeUtils.unescapeHtml4((String)body);
            try {
                body = HTMLSanitizer.sanitize((String)body);
            }
            catch (Exception e) {
                LOG.warn("Error sanitizing news '{}' body", new Object[]{news.getId()});
            }
            body = Utils.html2text((String)body);
            fields.put("body", body);
        }
        if (StringUtils.isNotBlank((CharSequence)summary)) {
            summary = StringEscapeUtils.unescapeHtml4((String)summary);
            try {
                summary = HTMLSanitizer.sanitize((String)summary);
            }
            catch (Exception e) {
                LOG.warn("Error sanitizing news '{}' summary", new Object[]{news.getId()});
            }
            summary = Utils.html2text((String)summary);
            fields.put("summary", summary);
        }
        if (StringUtils.isNotBlank((CharSequence)news.getAuthor())) {
            fields.put("posterId", news.getAuthor());
            Identity posterIdentity = this.identityManager.getOrCreateIdentity("organization", news.getAuthor());
            if (posterIdentity != null && posterIdentity.getProfile() != null && StringUtils.isNotBlank((CharSequence)posterIdentity.getProfile().getFullName())) {
                fields.put("posterName", posterIdentity.getProfile().getFullName());
            }
        }
        if (news.getSpaceDisplayName() != null) {
            fields.put("spaceDisplayName", news.getSpaceDisplayName());
        }
        String newsActivities = news.getActivities();
        String ownerIdentityId = null;
        if (newsActivities != null) {
            String newsActivityId = newsActivities.split(";")[0].split(":")[1];
            fields.put("newsActivityId", newsActivityId);
            ExoSocialActivity newsActivity = this.activityManager.getActivity(newsActivityId);
            ActivityStream activityStream = newsActivity.getActivityStream();
            if (newsActivity.getParentId() != null && (activityStream == null || activityStream.getType() == null || StringUtils.isBlank((CharSequence)activityStream.getPrettyId()))) {
                ExoSocialActivity parentActivity = this.activityManager.getActivity(newsActivity.getParentId());
                activityStream = parentActivity.getActivityStream();
            }
            if (activityStream != null && activityStream.getType() != null && StringUtils.isNotBlank((CharSequence)activityStream.getPrettyId())) {
                String prettyId = activityStream.getPrettyId();
                String providerId = activityStream.getType().getProviderId();
                Identity streamOwner = this.identityManager.getOrCreateIdentity(providerId, prettyId);
                ownerIdentityId = streamOwner.getId();
            }
        } else {
            return null;
        }
        if (news.getCreationDate() != null) {
            fields.put("postedTime", String.valueOf(news.getCreationDate().getTime()));
        }
        if (news.getUpdateDate() != null) {
            fields.put("lastUpdatedTime", String.valueOf(news.getUpdateDate().getTime()));
        }
        fields.put("lang", news.getLang());
        DocumentWithMetadata document = new DocumentWithMetadata();
        document.setId(id);
        document.setLastUpdatedDate(news.getUpdateDate());
        document.setPermissions(Collections.singleton(ownerIdentityId));
        document.setFields(fields);
        this.addDocumentMetadata(document, id);
        return document;
    }

    private void addDocumentMetadata(DocumentWithMetadata document, String documentId) {
        MetadataObject metadataObject = new MetadataObject(TYPE, documentId);
        List metadataItems = this.metadataService.getMetadataItemsByObject(metadataObject);
        document.setMetadataItems(metadataItems);
    }
}

