{ }
{ Thanks to Keith Chew for submitting this. }
{ }
{ use the StdJDBCDelegate with Informix. }
{ }
{ note that Informix has a 18 character limit on the table name, so the prefix had to be shortened to "q" instead of "qrtz_" }

CREATE TABLE qblob_triggers (
SCHED_NAME VARCHAR(120) NOT NULL,
TRIGGER_NAME varchar(80) NOT NULL,
TRIGGER_GROUP varchar(80) NOT NULL,
BLOB_DATA byte in table
);

ALTER TABLE qblob_triggers
ADD CONSTRAINT PRIMARY KEY (SCHED_NAME,TRIGGER_NAME, TRIGGER_GROUP);


CREATE TABLE qcalendars (
SCHED_NAME VARCHAR(120) NOT NULL,
CALENDAR_NAME varchar(80) NOT NULL,
CALENDAR byte in table NOT NULL
);

ALTER TABLE qcalendars
ADD CONSTRAINT PRIMARY KEY (SCHED_NAME,CALENDAR_NAME);


CREATE TABLE qcron_triggers (
SCHED_NAME VARCHAR(120) NOT NULL,
TRIGGER_NAME varchar(80) NOT NULL,
TRIGGER_GROUP varchar(80) NOT NULL,
CRON_EXPRESSION varchar(120) NOT NULL,
TIME_ZONE_ID varchar(80)
);

ALTER TABLE qcron_triggers
ADD CONSTRAINT PRIMARY KEY (SCHED_NAME,TRIGGER_NAME, TRIGGER_GROUP);


CREATE TABLE qfired_triggers (
SCHED_NAME VARCHAR(120) NOT NULL,
ENTRY_ID varchar(95) NOT NULL,
TRIGGER_NAME varchar(80) NOT NULL,
TRIGGER_GROUP varchar(80) NOT NULL,
INSTANCE_NAME varchar(80) NOT NULL,
FIRED_TIME numeric(13) NOT NULL,
SCHED_TIME numeric(13) NOT NULL,
PRIORITY integer NOT NULL,
STATE varchar(16) NOT NULL,
JOB_NAME varchar(80),
JOB_GROUP varchar(80),
IS_NONCONCURRENT varchar(1),
REQUESTS_RECOVERY varchar(1) 
);

ALTER TABLE qfired_triggers
ADD CONSTRAINT PRIMARY KEY (SCHED_NAME,ENTRY_ID);


CREATE TABLE qpaused_trigger_grps (
SCHED_NAME VARCHAR(120) NOT NULL,
TRIGGER_GROUP  varchar(80) NOT NULL
);

ALTER TABLE qpaused_trigger_grps
ADD CONSTRAINT PRIMARY KEY (SCHED_NAME,TRIGGER_GROUP);


CREATE TABLE qscheduler_state (
SCHED_NAME VARCHAR(120) NOT NULL,
INSTANCE_NAME varchar(80) NOT NULL,
LAST_CHECKIN_TIME numeric(13) NOT NULL,
CHECKIN_INTERVAL numeric(13) NOT NULL
);

ALTER TABLE qscheduler_state
ADD CONSTRAINT PRIMARY KEY (SCHED_NAME,INSTANCE_NAME);


CREATE TABLE qlocks (
SCHED_NAME VARCHAR(120) NOT NULL,
LOCK_NAME  varchar(40) NOT NULL
);

ALTER TABLE qlocks
ADD CONSTRAINT PRIMARY KEY (SCHED_NAME,LOCK_NAME);


CREATE TABLE qjob_details (
SCHED_NAME VARCHAR(120) NOT NULL,
JOB_NAME varchar(80) NOT NULL,
JOB_GROUP varchar(80) NOT NULL,
DESCRIPTION varchar(120),
JOB_CLASS_NAME varchar(128) NOT NULL,
IS_DURABLE varchar(1) NOT NULL,
IS_NONCONCURRENT varchar(1) NOT NULL,
IS_UPDATE_DATA varchar(1) NOT NULL,
REQUESTS_RECOVERY varchar(1) NOT NULL,
JOB_DATA byte in table
);

ALTER TABLE qjob_details
ADD CONSTRAINT PRIMARY KEY (SCHED_NAME,JOB_NAME, JOB_GROUP);


CREATE TABLE qsimple_triggers (
SCHED_NAME VARCHAR(120) NOT NULL,
TRIGGER_NAME varchar(80) NOT NULL,
TRIGGER_GROUP varchar(80) NOT NULL,
REPEAT_COUNT numeric(7) NOT NULL,
REPEAT_INTERVAL numeric(12) NOT NULL,
TIMES_TRIGGERED numeric(10) NOT NULL
);

ALTER TABLE qsimple_triggers
ADD CONSTRAINT PRIMARY KEY (SCHED_NAME,TRIGGER_NAME, TRIGGER_GROUP);


CREATE TABLE qsimprop_triggers
  (          
    SCHED_NAME VARCHAR(120) NOT NULL,
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    STR_PROP_1 VARCHAR(512) NULL,
    STR_PROP_2 VARCHAR(512) NULL,
    STR_PROP_3 VARCHAR(512) NULL,
    INT_PROP_1 NUMERIC(9) NULL,
    INT_PROP_2 NUMERIC(9) NULL,
    LONG_PROP_1 NUMERIC(13) NULL,
    LONG_PROP_2 NUMERIC(13) NULL,
    DEC_PROP_1 NUMERIC(13,4) NULL,
    DEC_PROP_2 NUMERIC(13,4) NULL,
    BOOL_PROP_1 VARCHAR(1) NULL,
    BOOL_PROP_2 VARCHAR(1) NULL,
);

ALTER TABLE qsimprop_triggers
ADD CONSTRAINT PRIMARY KEY (SCHED_NAME,TRIGGER_NAME, TRIGGER_GROUP);


CREATE TABLE qtriggers (
SCHED_NAME VARCHAR(120) NOT NULL,
TRIGGER_NAME varchar(80) NOT NULL,
TRIGGER_GROUP varchar(80) NOT NULL,
JOB_NAME varchar(80) NOT NULL,
JOB_GROUP varchar(80) NOT NULL,
DESCRIPTION varchar(120),
NEXT_FIRE_TIME numeric(13),
PREV_FIRE_TIME numeric(13),
PRIORITY integer,
TRIGGER_STATE varchar(16) NOT NULL,
TRIGGER_TYPE varchar(8) NOT NULL,
START_TIME numeric(13) NOT NULL,
END_TIME numeric(13),
CALENDAR_NAME varchar(80),
MISFIRE_INSTR numeric(2),
JOB_DATA byte in table
);

ALTER TABLE qtriggers
ADD CONSTRAINT PRIMARY KEY (SCHED_NAME,TRIGGER_NAME, TRIGGER_GROUP);


ALTER TABLE qblob_triggers
ADD CONSTRAINT FOREIGN KEY (SCHED_NAME,TRIGGER_NAME, TRIGGER_GROUP)
REFERENCES qtriggers;


ALTER TABLE qcron_triggers
ADD CONSTRAINT FOREIGN KEY (SCHED_NAME,TRIGGER_NAME, TRIGGER_GROUP)
REFERENCES qtriggers;


ALTER TABLE qsimple_triggers
ADD CONSTRAINT FOREIGN KEY (SCHED_NAME,TRIGGER_NAME, TRIGGER_GROUP)
REFERENCES qtriggers;

ALTER TABLE qsimprop_triggers
ADD CONSTRAINT FOREIGN KEY (SCHED_NAME,TRIGGER_NAME, TRIGGER_GROUP)
REFERENCES qtriggers;

ALTER TABLE qtriggers
ADD CONSTRAINT FOREIGN KEY (SCHED_NAME,JOB_NAME, JOB_GROUP)
REFERENCES qjob_details; 

