/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentTypeResolver;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Distinct;
import org.hibernate.sql.ast.tree.expression.Star;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.SortSpecification;

public class NamedSqmFunctionDescriptor
extends AbstractSqmSelfRenderingFunctionDescriptor {
    private final String functionName;
    private final boolean useParenthesesWhenNoArgs;
    private final String argumentListSignature;
    private final SqlAstNodeRenderingMode argumentRenderingMode;

    public NamedSqmFunctionDescriptor(String functionName, boolean useParenthesesWhenNoArgs, ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver) {
        this(functionName, useParenthesesWhenNoArgs, argumentsValidator, returnTypeResolver, null, functionName, FunctionKind.NORMAL, null, SqlAstNodeRenderingMode.DEFAULT);
    }

    public NamedSqmFunctionDescriptor(String functionName, boolean useParenthesesWhenNoArgs, ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver, FunctionArgumentTypeResolver argumentTypeResolver) {
        this(functionName, useParenthesesWhenNoArgs, argumentsValidator, returnTypeResolver, argumentTypeResolver, functionName, FunctionKind.NORMAL, null, SqlAstNodeRenderingMode.DEFAULT);
    }

    public NamedSqmFunctionDescriptor(String functionName, boolean useParenthesesWhenNoArgs, ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver, FunctionArgumentTypeResolver argumentTypeResolver, String name, FunctionKind functionKind, String argumentListSignature, SqlAstNodeRenderingMode argumentRenderingMode) {
        super(name, functionKind, argumentsValidator, returnTypeResolver, argumentTypeResolver);
        this.functionName = functionName;
        this.useParenthesesWhenNoArgs = useParenthesesWhenNoArgs;
        this.argumentListSignature = argumentListSignature;
        this.argumentRenderingMode = argumentRenderingMode;
    }

    @Override
    public String getName() {
        return this.functionName;
    }

    @Override
    public String getArgumentListSignature() {
        return this.argumentListSignature == null ? super.getArgumentListSignature() : this.argumentListSignature;
    }

    @Override
    public boolean alwaysIncludesParentheses() {
        return this.useParenthesesWhenNoArgs;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> translator) {
        this.render(sqlAppender, sqlAstArguments, null, Collections.emptyList(), null, null, translator);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, Predicate filter, ReturnableType<?> returnType, SqlAstTranslator<?> translator) {
        this.render(sqlAppender, sqlAstArguments, filter, Collections.emptyList(), null, null, translator);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, Predicate filter, List<SortSpecification> withinGroup, ReturnableType<?> returnType, SqlAstTranslator<?> translator) {
        this.render(sqlAppender, sqlAstArguments, filter, withinGroup, null, null, translator);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, Predicate filter, Boolean respectNulls, Boolean fromFirst, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        this.render(sqlAppender, sqlAstArguments, filter, Collections.emptyList(), respectNulls, fromFirst, walker);
    }

    private void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, Predicate filter, List<SortSpecification> withinGroup, Boolean respectNulls, Boolean fromFirst, SqlAstTranslator<?> translator) {
        boolean useParens = this.useParenthesesWhenNoArgs || !sqlAstArguments.isEmpty();
        boolean caseWrapper = filter != null && !translator.supportsFilterClause();
        sqlAppender.appendSql(this.functionName);
        if (useParens) {
            sqlAppender.appendSql("(");
        }
        boolean firstPass = true;
        for (SqlAstNode sqlAstNode : sqlAstArguments) {
            if (!firstPass) {
                sqlAppender.appendSql(",");
            }
            if (caseWrapper && !(sqlAstNode instanceof Distinct)) {
                translator.getCurrentClauseStack().push(Clause.WHERE);
                sqlAppender.appendSql("case when ");
                filter.accept(translator);
                translator.getCurrentClauseStack().pop();
                sqlAppender.appendSql(" then ");
                if (sqlAstNode instanceof Star) {
                    sqlAppender.appendSql("1");
                } else {
                    translator.render(sqlAstNode, this.argumentRenderingMode);
                }
                sqlAppender.appendSql(" else null end");
            } else {
                translator.render(sqlAstNode, this.argumentRenderingMode);
            }
            firstPass = false;
        }
        if (useParens) {
            sqlAppender.appendSql(")");
        }
        if (withinGroup != null && !withinGroup.isEmpty()) {
            translator.getCurrentClauseStack().push(Clause.WITHIN_GROUP);
            sqlAppender.appendSql(" within group (order by");
            translator.render(withinGroup.get(0), this.argumentRenderingMode);
            for (int i = 1; i < withinGroup.size(); ++i) {
                sqlAppender.appendSql(',');
                translator.render(withinGroup.get(0), this.argumentRenderingMode);
            }
            sqlAppender.appendSql(')');
            translator.getCurrentClauseStack().pop();
        }
        if (fromFirst != null) {
            if (fromFirst.booleanValue()) {
                sqlAppender.appendSql(" from first");
            } else {
                sqlAppender.appendSql(" from last");
            }
        }
        if (respectNulls != null) {
            if (respectNulls.booleanValue()) {
                sqlAppender.appendSql(" respect nulls");
            } else {
                sqlAppender.appendSql(" ignore nulls");
            }
        }
        if (filter != null && !caseWrapper) {
            translator.getCurrentClauseStack().push(Clause.WHERE);
            sqlAppender.appendSql(" filter (where ");
            filter.accept(translator);
            sqlAppender.appendSql(')');
            translator.getCurrentClauseStack().pop();
        }
    }

    public String toString() {
        return String.format(Locale.ROOT, "NamedSqmFunctionTemplate(%s)", this.functionName);
    }
}

