/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.system;

import java.io.Console;
import java.io.Reader;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.Future;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.util.ClassUtils;

public enum JavaVersion {
    SEVENTEEN("17", Console.class, "charset", new Class[0]),
    EIGHTEEN("18", Duration.class, "isPositive", new Class[0]),
    NINETEEN("19", Future.class, "state", new Class[0]),
    TWENTY("20", Class.class, "accessFlags", new Class[0]),
    TWENTY_ONE("21", SortedSet.class, "getFirst", new Class[0]),
    TWENTY_TWO("22", Console.class, "isTerminal", new Class[0]),
    TWENTY_THREE("23", NumberFormat.class, "isStrict", new Class[0]),
    TWENTY_FOUR("24", Reader.class, "of", CharSequence.class),
    TWENTY_FIVE("25", Reader.class, "readAllLines", new Class[0]);

    private final String name;
    private final boolean available;
    private final Class<?> versionSpecificClass;
    private final String versionSpecificMethod;
    private final Class<?>[] paramTypes;

    private JavaVersion(String name, Class<?> versionSpecificClass, String versionSpecificMethod, Class<?> ... paramTypes) {
        this.name = name;
        this.versionSpecificClass = versionSpecificClass;
        this.versionSpecificMethod = versionSpecificMethod;
        this.paramTypes = paramTypes;
        this.available = ClassUtils.hasMethod(versionSpecificClass, (String)versionSpecificMethod, (Class[])paramTypes);
    }

    public String toString() {
        return this.name;
    }

    public static JavaVersion getJavaVersion() {
        List<JavaVersion> candidates = Arrays.asList(JavaVersion.values());
        Collections.reverse(candidates);
        for (JavaVersion candidate : candidates) {
            if (!candidate.available) continue;
            return candidate;
        }
        return SEVENTEEN;
    }

    public boolean isEqualOrNewerThan(JavaVersion version) {
        return this.compareTo(version) >= 0;
    }

    public boolean isOlderThan(JavaVersion version) {
        return this.compareTo(version) < 0;
    }

    static class Hints
    implements RuntimeHintsRegistrar {
        Hints() {
        }

        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            for (JavaVersion javaVersion : JavaVersion.values()) {
                Method method = this.findMethod(javaVersion);
                if (method == null) continue;
                hints.reflection().registerMethod(method, ExecutableMode.INTROSPECT);
            }
        }

        private Method findMethod(JavaVersion javaVersion) {
            try {
                return ClassUtils.getMethod(javaVersion.versionSpecificClass, (String)javaVersion.versionSpecificMethod, (Class[])javaVersion.paramTypes);
            }
            catch (IllegalStateException ex) {
                return null;
            }
        }
    }
}

