/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ecs.examples;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.ecs.html.A;
import org.apache.ecs.html.NOBR;
import org.apache.ecs.html.TD;
import org.apache.ecs.html.TR;
import org.apache.ecs.html.Table;
import org.apache.ecs.xml.XML;

public class HtmlTree
implements Serializable {
    protected int indentation = 2;
    protected String path = "";
    protected String parameterName = "path";
    private int[] pathArray = new int[0];
    protected String leafIcon = "";
    protected String openIcon = "";
    protected String closedIcon = "";
    protected String action = "?";
    protected boolean rootVisible = true;
    protected DefaultMutableTreeNode root;
    protected DefaultMutableTreeNode displayNode = this.root = HtmlTree.getDefaultTreeModel();

    public HtmlTree() {
    }

    public HtmlTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.setRoot(defaultMutableTreeNode);
    }

    public HtmlTree(DefaultTreeModel defaultTreeModel) {
        this.setModel(defaultTreeModel);
    }

    public static String encodeToHtml(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (string != null && n < string.length()) {
            char c = string.charAt(n);
            if (c == '\'') {
                stringBuffer.append("&#039;");
            } else if (c == '\"') {
                stringBuffer.append("&quot;");
            } else if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    protected static DefaultMutableTreeNode getDefaultTreeModel() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Root");
        int n = 1;
        while (n <= 5) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Folder-" + n);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            int n2 = 1;
            while (n2 <= 3) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Subfolder-" + n2);
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                int n3 = 1;
                while (n3 <= 3) {
                    A a2 = new A("http://jakarta.apache.org");
                    a2.setTarget("target").addElement("Document-" + n3);
                    DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(a2.toString());
                    defaultMutableTreeNode3.add(defaultMutableTreeNode4);
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return defaultMutableTreeNode;
    }

    public String getHtml() {
        Object object2;
        TD tD;
        this.displayNode = this.getRequestedNode();
        Table table2 = new Table();
        table2.setClass("tree");
        int n = 0;
        TreeNode treeNode = this.displayNode.getFirstChild();
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        while ((treeNode = treeNode.getParent()) != null) {
            arrayList.add(treeNode);
        }
        int n2 = arrayList.size();
        while (n2 > 0) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)arrayList.get(n2 - 1);
            if (!defaultMutableTreeNode.isRoot() || this.rootVisible) {
                tD = new TD();
                tD.setClass("parent");
                object2 = String.valueOf(this.action) + this.parameterName + "=" + this.getPath(defaultMutableTreeNode.getLevel() - 1);
                int n3 = 0;
                while (n3 < n) {
                    tD.addElement("&nbsp;");
                    ++n3;
                }
                tD.addElement(new A((String)object2, this.getImg(this.openIcon)));
                tD.addElement(new NOBR(defaultMutableTreeNode.toString()));
                table2.addElement(new TR(tD));
                n += this.indentation;
            }
            --n2;
        }
        int n4 = 0;
        while (n4 < this.displayNode.getChildCount()) {
            tD = new TD();
            tD.setClass("child");
            object2 = (DefaultMutableTreeNode)this.displayNode.getChildAt(n4);
            String string = String.valueOf(this.getPath(((DefaultMutableTreeNode)object2).getLevel() - 1)) + ":" + n4;
            if (string.startsWith(":")) {
                string = string.substring(1);
            }
            String string2 = String.valueOf(this.action) + this.parameterName + "=" + string;
            int n5 = 0;
            while (n5 < n) {
                tD.addElement("&nbsp;");
                ++n5;
            }
            String string3 = this.getImg(this.leafIcon);
            if (!((DefaultMutableTreeNode)object2).isLeaf()) {
                string3 = this.getImg(this.closedIcon);
            }
            if (!((DefaultMutableTreeNode)object2).isLeaf()) {
                tD.addElement(new A(string2, string3));
            }
            if (((DefaultMutableTreeNode)object2).isLeaf()) {
                tD.addElement(string3);
            }
            tD.addElement(new NOBR(((DefaultMutableTreeNode)object2).toString()));
            table2.addElement(new TR(tD));
            ++n4;
        }
        return table2.toString();
    }

    public String getImg(String string) {
        XML xML = new XML("img", false);
        if (string == null) {
            string = "";
        }
        xML.addAttribute("src", string);
        return xML.toString();
    }

    public int getIndentation() {
        return this.indentation;
    }

    public DefaultTreeModel getModel() {
        return new DefaultTreeModel(this.root);
    }

    public String getNodeName() {
        return this.displayNode.toString();
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String getPath() {
        return this.path;
    }

    public String getPath(int n) {
        if (n > this.pathArray.length) {
            n = this.pathArray.length;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(this.pathArray[n2]);
            if (n2 < n - 1) {
                stringBuffer.append(":");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static int[] getPathResolved(String string) throws NumberFormatException {
        try {
            int[] nArray = new int[]{};
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            nArray = new int[stringTokenizer.countTokens()];
            if (stringTokenizer.countTokens() > 0) {
                int n = 0;
                while (n < nArray.length) {
                    nArray[n] = Integer.parseInt(stringTokenizer.nextToken().trim());
                    ++n;
                }
            }
            return nArray;
        }
        catch (Exception exception) {
            throw new NumberFormatException(exception.getMessage());
        }
    }

    public DefaultMutableTreeNode getRequestedNode() {
        this.displayNode = this.root;
        int n = 0;
        while (n < this.pathArray.length) {
            if (this.displayNode.getDepth() > 1) {
                this.displayNode = (DefaultMutableTreeNode)this.displayNode.getChildAt(this.pathArray[n]);
            }
            ++n;
        }
        return this.displayNode;
    }

    public DefaultMutableTreeNode getRoot() {
        return this.root;
    }

    public int getRowCount() {
        int n = this.displayNode.getLevel();
        n += this.displayNode.getChildCount();
        if (this.rootVisible) {
            ++n;
        }
        return n;
    }

    public boolean isRootVisible() {
        return this.rootVisible;
    }

    public void setAction(String string) {
        if (string == null) {
            string = "";
        }
        string = string.indexOf("=") != -1 ? String.valueOf(string) + "&" : String.valueOf(string) + "?";
        this.action = string;
    }

    public void setClosedIcon(String string) {
        this.closedIcon = string;
    }

    public void setIndentation(int n) {
        this.indentation = n;
    }

    public void setLeafIcon(String string) {
        this.leafIcon = string;
    }

    public void setModel(DefaultTreeModel defaultTreeModel) {
        if (defaultTreeModel != null) {
            this.setRoot((DefaultMutableTreeNode)defaultTreeModel.getRoot());
        } else {
            this.setRoot(null);
        }
    }

    public void setOpenIcon(String string) {
        this.openIcon = string;
    }

    public void setParameterName(String string) {
        if (string == null || string.equals("")) {
            string = "path";
        }
        this.parameterName = string;
    }

    public void setPath(String string) {
        try {
            this.pathArray = HtmlTree.getPathResolved(string);
            this.path = string;
        }
        catch (NumberFormatException numberFormatException) {
            this.path = "";
        }
    }

    public void setRoot(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = HtmlTree.getDefaultTreeModel();
        }
        this.root = defaultMutableTreeNode;
    }

    public void setRootVisible(boolean bl) {
        this.rootVisible = bl;
    }

    public String toString() {
        return this.getHtml();
    }
}

