/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.plugin;

import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.service.ProgramService;
import io.meeds.gamification.service.RuleService;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.ActivityTypePlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;

public class RuleActivityTypePlugin
extends ActivityTypePlugin {
    private ProgramService programService;
    private RuleService ruleService;

    public RuleActivityTypePlugin(ProgramService programService, RuleService ruleService, InitParams params) {
        super(params);
        this.programService = programService;
        this.ruleService = ruleService;
    }

    public boolean isActivityViewable(ExoSocialActivity activity, Identity userAclIdentity) {
        long ruleId = Long.parseLong(activity.getMetadataObjectId());
        RuleDTO rule = this.ruleService.findRuleById(ruleId);
        if (rule == null || rule.getActivityId() != Long.parseLong(activity.getId())) {
            throw new UnsupportedOperationException();
        }
        return this.programService.canViewProgram(rule.getProgramId(), userAclIdentity.getUserId());
    }
}

