/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.regex.Pattern;
import org.hibernate.query.SemanticException;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;

public class SqmFormat
extends SqmLiteral<String> {
    private static final Pattern FORMAT = Pattern.compile("('[^']+'|[:;/,.!@#$^&?~`|()\\[\\]{}<>\\-+*=]|\\s|G{1,2}|[yY]{1,4}|M{1,4}|w{1,2}|W|E{3,4}|e{1,2}|d{1,2}|D{1,3}|a|[Hhms]{1,2}|S{1,6}|[zZx]{1,3})*");

    public SqmFormat(String value, SqmExpressible<String> inherentType, NodeBuilder nodeBuilder) {
        super(value, inherentType, nodeBuilder);
        if (!FORMAT.matcher(value).matches()) {
            throw new SemanticException("Illegal format pattern '" + value + "'");
        }
    }

    @Override
    public SqmFormat copy(SqmCopyContext context) {
        SqmFormat existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmFormat expression = context.registerCopy(this, new SqmFormat((String)this.getLiteralValue(), this.getNodeType(), (NodeBuilder)this.nodeBuilder()));
        this.copyTo(expression, context);
        return expression;
    }

    @Override
    public <R> R accept(SemanticQueryWalker<R> walker) {
        return walker.visitFormat(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append((String)this.getLiteralValue());
    }
}

