/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.elasticsearch.ingest.UserAgentProperty;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UserAgentProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    @Nullable
    private final Boolean ignoreMissing;
    @Nullable
    private final String regexFile;
    @Nullable
    private final String targetField;
    private final List<UserAgentProperty> properties;
    @Nullable
    private final Boolean extractDeviceType;
    public static final JsonpDeserializer<UserAgentProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UserAgentProcessor::setupUserAgentProcessorDeserializer);

    private UserAgentProcessor(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.ignoreMissing = builder.ignoreMissing;
        this.regexFile = builder.regexFile;
        this.targetField = builder.targetField;
        this.properties = ApiTypeHelper.unmodifiable(builder.properties);
        this.extractDeviceType = builder.extractDeviceType;
    }

    public static UserAgentProcessor of(Function<Builder, ObjectBuilder<UserAgentProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.UserAgent;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Nullable
    public final String regexFile() {
        return this.regexFile;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    public final List<UserAgentProperty> properties() {
        return this.properties;
    }

    @Nullable
    public final Boolean extractDeviceType() {
        return this.extractDeviceType;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
        if (this.regexFile != null) {
            generator.writeKey("regex_file");
            generator.write(this.regexFile);
        }
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
        if (ApiTypeHelper.isDefined(this.properties)) {
            generator.writeKey("properties");
            generator.writeStartArray();
            for (UserAgentProperty item0 : this.properties) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.extractDeviceType != null) {
            generator.writeKey("extract_device_type");
            generator.write(this.extractDeviceType.booleanValue());
        }
    }

    protected static void setupUserAgentProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
        op.add(Builder::regexFile, JsonpDeserializer.stringDeserializer(), "regex_file");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
        op.add(Builder::properties, JsonpDeserializer.arrayDeserializer(UserAgentProperty._DESERIALIZER), "properties");
        op.add(Builder::extractDeviceType, JsonpDeserializer.booleanDeserializer(), "extract_device_type");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UserAgentProcessor> {
        private String field;
        @Nullable
        private Boolean ignoreMissing;
        @Nullable
        private String regexFile;
        @Nullable
        private String targetField;
        @Nullable
        private List<UserAgentProperty> properties;
        @Nullable
        private Boolean extractDeviceType;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public final Builder regexFile(@Nullable String value) {
            this.regexFile = value;
            return this;
        }

        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        public final Builder properties(List<UserAgentProperty> list) {
            this.properties = Builder._listAddAll(this.properties, list);
            return this;
        }

        public final Builder properties(UserAgentProperty value, UserAgentProperty ... values) {
            this.properties = Builder._listAdd(this.properties, value, values);
            return this;
        }

        public final Builder extractDeviceType(@Nullable Boolean value) {
            this.extractDeviceType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UserAgentProcessor build() {
            this._checkSingleUse();
            return new UserAgentProcessor(this);
        }
    }
}

