/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.ObjectJdbcType;
import org.hibernate.type.descriptor.jdbc.VarbinaryJdbcType;

public class ObjectNullAsNullTypeJdbcType
extends ObjectJdbcType {
    public static final ObjectNullAsNullTypeJdbcType INSTANCE = new ObjectNullAsNullTypeJdbcType(2000);

    public ObjectNullAsNullTypeJdbcType(int jdbcTypeCode) {
        super(jdbcTypeCode);
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        if (Serializable.class.isAssignableFrom(javaType.getJavaTypeClass())) {
            return VarbinaryJdbcType.INSTANCE.getBinder(javaType);
        }
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBindNull(PreparedStatement st, int index, WrapperOptions options) throws SQLException {
                st.setNull(index, 0);
            }

            @Override
            protected void doBindNull(CallableStatement st, String name, WrapperOptions options) throws SQLException {
                st.setNull(name, 0);
            }

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setObject(index, value, ObjectNullAsNullTypeJdbcType.this.getJdbcTypeCode());
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setObject(name, value, ObjectNullAsNullTypeJdbcType.this.getJdbcTypeCode());
            }
        };
    }
}

