/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core;

import java.util.Iterator;
import liquibase.Scope;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.core.StartH2CommandStep;

public class StopH2CommandStep
extends AbstractCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"init", "stopH2"};

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setHidden(true);
    }

    @Override
    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        Iterator<Thread> iterator = StartH2CommandStep.RUNNING_THREADS.iterator();
        while (iterator.hasNext()) {
            Thread runningThread = iterator.next();
            try {
                runningThread.interrupt();
                iterator.remove();
            }
            catch (Exception e) {
                Scope.getCurrentScope().getLog(this.getClass()).warning("Error stopping H2 thread", e);
            }
        }
    }
}

