/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.inference.InferenceChunkingSettings;
import co.elastic.clients.elasticsearch.inference.PutVoyageaiResponse;
import co.elastic.clients.elasticsearch.inference.VoyageAIServiceSettings;
import co.elastic.clients.elasticsearch.inference.VoyageAIServiceType;
import co.elastic.clients.elasticsearch.inference.VoyageAITaskSettings;
import co.elastic.clients.elasticsearch.inference.VoyageAITaskType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutVoyageaiRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final InferenceChunkingSettings chunkingSettings;
    private final VoyageAIServiceType service;
    private final VoyageAIServiceSettings serviceSettings;
    @Nullable
    private final VoyageAITaskSettings taskSettings;
    private final VoyageAITaskType taskType;
    @Nullable
    private final Time timeout;
    private final String voyageaiInferenceId;
    public static final JsonpDeserializer<PutVoyageaiRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutVoyageaiRequest::setupPutVoyageaiRequestDeserializer);
    public static final Endpoint<PutVoyageaiRequest, PutVoyageaiResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutVoyageaiRequest, PutVoyageaiResponse>("es/inference.put_voyageai", request -> "PUT", request -> {
        boolean _voyageaiInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.voyageaiInferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _voyageaiInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("voyageaiInferenceId", request.voyageaiInferenceId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutVoyageaiResponse._DESERIALIZER);

    private PutVoyageaiRequest(Builder builder) {
        this.chunkingSettings = builder.chunkingSettings;
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
        this.serviceSettings = ApiTypeHelper.requireNonNull(builder.serviceSettings, this, "serviceSettings");
        this.taskSettings = builder.taskSettings;
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
        this.timeout = builder.timeout;
        this.voyageaiInferenceId = ApiTypeHelper.requireNonNull(builder.voyageaiInferenceId, this, "voyageaiInferenceId");
    }

    public static PutVoyageaiRequest of(Function<Builder, ObjectBuilder<PutVoyageaiRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final InferenceChunkingSettings chunkingSettings() {
        return this.chunkingSettings;
    }

    public final VoyageAIServiceType service() {
        return this.service;
    }

    public final VoyageAIServiceSettings serviceSettings() {
        return this.serviceSettings;
    }

    @Nullable
    public final VoyageAITaskSettings taskSettings() {
        return this.taskSettings;
    }

    public final VoyageAITaskType taskType() {
        return this.taskType;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public final String voyageaiInferenceId() {
        return this.voyageaiInferenceId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.chunkingSettings != null) {
            generator.writeKey("chunking_settings");
            this.chunkingSettings.serialize(generator, mapper);
        }
        generator.writeKey("service");
        this.service.serialize(generator, mapper);
        generator.writeKey("service_settings");
        this.serviceSettings.serialize(generator, mapper);
        if (this.taskSettings != null) {
            generator.writeKey("task_settings");
            this.taskSettings.serialize(generator, mapper);
        }
    }

    protected static void setupPutVoyageaiRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::chunkingSettings, InferenceChunkingSettings._DESERIALIZER, "chunking_settings");
        op.add(Builder::service, VoyageAIServiceType._DESERIALIZER, "service");
        op.add(Builder::serviceSettings, VoyageAIServiceSettings._DESERIALIZER, "service_settings");
        op.add(Builder::taskSettings, VoyageAITaskSettings._DESERIALIZER, "task_settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutVoyageaiRequest> {
        @Nullable
        private InferenceChunkingSettings chunkingSettings;
        private VoyageAIServiceType service;
        private VoyageAIServiceSettings serviceSettings;
        @Nullable
        private VoyageAITaskSettings taskSettings;
        private VoyageAITaskType taskType;
        @Nullable
        private Time timeout;
        private String voyageaiInferenceId;

        public final Builder chunkingSettings(@Nullable InferenceChunkingSettings value) {
            this.chunkingSettings = value;
            return this;
        }

        public final Builder chunkingSettings(Function<InferenceChunkingSettings.Builder, ObjectBuilder<InferenceChunkingSettings>> fn) {
            return this.chunkingSettings(fn.apply(new InferenceChunkingSettings.Builder()).build());
        }

        public final Builder service(VoyageAIServiceType value) {
            this.service = value;
            return this;
        }

        public final Builder serviceSettings(VoyageAIServiceSettings value) {
            this.serviceSettings = value;
            return this;
        }

        public final Builder serviceSettings(Function<VoyageAIServiceSettings.Builder, ObjectBuilder<VoyageAIServiceSettings>> fn) {
            return this.serviceSettings(fn.apply(new VoyageAIServiceSettings.Builder()).build());
        }

        public final Builder taskSettings(@Nullable VoyageAITaskSettings value) {
            this.taskSettings = value;
            return this;
        }

        public final Builder taskSettings(Function<VoyageAITaskSettings.Builder, ObjectBuilder<VoyageAITaskSettings>> fn) {
            return this.taskSettings(fn.apply(new VoyageAITaskSettings.Builder()).build());
        }

        public final Builder taskType(VoyageAITaskType value) {
            this.taskType = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder voyageaiInferenceId(String value) {
            this.voyageaiInferenceId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutVoyageaiRequest build() {
            this._checkSingleUse();
            return new PutVoyageaiRequest(this);
        }
    }
}

