/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.evm.gamification.listener;

import io.meeds.evm.gamification.listener.RuleCheckForHoldEventListener$AjcClosure1;
import io.meeds.evm.gamification.service.EvmBlockchainService;
import io.meeds.evm.gamification.service.EvmContractTransferService;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.utils.Utils;
import io.meeds.wallet.model.Wallet;
import io.meeds.wallet.service.WalletAccountService;
import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RuleCheckForHoldEventListener
extends Listener<Long, String> {
    private static final List<String> SUPPORTED_EVENTS;
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private RuleService ruleService;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private WalletAccountService walletAccountService;
    @Autowired
    private EvmBlockchainService evmBlockchainService;
    @Autowired
    private EvmContractTransferService evmContractTransferService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    public void init() {
        for (String eventName : SUPPORTED_EVENTS) {
            this.listenerService.addListener(eventName, (ListenerBase)this);
        }
    }

    @ExoTransactional
    public void onEvent(Event<Long, String> event) {
        Event<Long, String> event2 = event;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), event2);
        Object[] objectArray = new Object[]{this, event2, joinPoint};
        RuleCheckForHoldEventListener$AjcClosure1 ruleCheckForHoldEventListener$AjcClosure1 = new RuleCheckForHoldEventListener$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(ruleCheckForHoldEventListener$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    static {
        RuleCheckForHoldEventListener.ajc$preClinit();
        SUPPORTED_EVENTS = Arrays.asList("rule.created", "rule.updated");
    }

    static final /* synthetic */ void onEvent_aroundBody0(RuleCheckForHoldEventListener ajc$this, Event event, JoinPoint joinPoint) {
        Long ruleId = (Long)event.getSource();
        RuleDTO rule = ajc$this.ruleService.findRuleById(ruleId.longValue());
        if (rule.getProgram() == null || !rule.getProgram().isEnabled() || rule.getEvent() == null || !StringUtils.equals((CharSequence)"holdToken", (CharSequence)rule.getEvent().getTrigger())) {
            return;
        }
        String trigger = rule.getEvent().getTrigger();
        Long spaceId = rule.getProgram().getSpaceId();
        String contractAddress = ((String)rule.getEvent().getProperties().get("contractAddress")).toLowerCase();
        String blockchainNetwork = (String)rule.getEvent().getProperties().get("blockchainNetwork");
        Long networkId = Long.parseLong((String)rule.getEvent().getProperties().get("networkId"));
        Long duration = Long.parseLong((String)rule.getEvent().getProperties().get("duration"));
        org.web3j.abi.datatypes.Event blockchainEvent = ajc$this.evmBlockchainService.isERC1155(blockchainNetwork, contractAddress) ? io.meeds.evm.gamification.utils.Utils.TRANSFERSINGLE_EVENT : (ajc$this.evmBlockchainService.isERC721(blockchainNetwork, contractAddress) ? io.meeds.evm.gamification.utils.Utils.TRANSFER_EVENT_ER721 : io.meeds.evm.gamification.utils.Utils.TRANSFER_EVENT_ERC20);
        if (spaceId == 0L) {
            Set wallets = ajc$this.walletAccountService.listWallets();
            List<String> walletsAddresses = wallets.stream().map(Wallet::getAddress).collect(Collectors.toList());
            walletsAddresses.forEach(walletAddress -> {
                if (event.getEventName().equals("rule.created")) {
                    this.evmContractTransferService.handleHoldEvent(blockchainNetwork, contractAddress, (String)walletAddress, networkId, duration, rule, blockchainEvent, trigger, null);
                } else if (event.getEventName().equals("rule.updated")) {
                    this.evmContractTransferService.saveLastRewardTime((String)walletAddress, rule.getId());
                }
            });
        } else {
            Space space = ajc$this.spaceService.getSpaceById(String.valueOf(spaceId));
            String[] members = space.getMembers();
            Arrays.stream(members).forEach(member -> {
                Long identityId = Long.parseLong(Utils.getUserIdentity((String)member).getId());
                String walletAddress = this.walletAccountService.getWalletByIdentityId(identityId.longValue()).getAddress();
                if (event.getEventName().equals("rule.created")) {
                    this.evmContractTransferService.handleHoldEvent(blockchainNetwork, contractAddress, walletAddress, networkId, duration, rule, blockchainEvent, trigger, null);
                } else if (event.getEventName().equals("rule.updated")) {
                    this.evmContractTransferService.saveLastRewardTime(walletAddress, rule.getId());
                }
            });
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RuleCheckForHoldEventListener.java", RuleCheckForHoldEventListener.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onEvent", "io.meeds.evm.gamification.listener.RuleCheckForHoldEventListener", "org.exoplatform.services.listener.Event", "event", "", "void"), 81);
    }
}

