/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pom.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Utils {
    public static final String USER_NAME_VALIDATOR_REGEX = "^[\\p{L}][\\p{L}._\\-\\d]+$";
    public static final String FIRST_CHARACTER_NAME_VALIDATOR_REGEX = "^[\\p{L}][\\p{L}._'\\- \\d]+$";

    public static String join(String separator, String ... strings) {
        if (strings == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            String o = strings[i];
            if (i > 0) {
                sb.append(separator);
            }
            sb.append((Object)o);
        }
        return sb.toString();
    }

    public static String join(String separator, List<String> strings) {
        if (strings == null) {
            return null;
        }
        String[] array = strings.toArray(new String[strings.size()]);
        return Utils.join(separator, array);
    }

    public static String[] split(String separator, String s) {
        if (s == null) {
            return null;
        }
        return Utils.split(s, 0, 0, separator);
    }

    public static <E> List<E> safeImmutableList(E ... list) {
        if (list == null || list.length == 0) {
            return Collections.emptyList();
        }
        if (list.length == 1) {
            E e = list[0];
            return Collections.singletonList(e);
        }
        List<E> copy = Arrays.asList(list);
        return Collections.unmodifiableList(copy);
    }

    public static <E> List<E> safeImmutableList(List<E> list) {
        if (list == null || list.size() == 0) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            E e = list.get(0);
            return Collections.singletonList(e);
        }
        ArrayList<E> copy = new ArrayList<E>(list);
        return Collections.unmodifiableList(copy);
    }

    public static <K, V> Map<K, V> safeImmutableMap(Map<K, V> map) {
        if (map == null || map.size() == 0) {
            return Collections.emptyMap();
        }
        if (map.size() == 1) {
            Map.Entry<K, V> entry = map.entrySet().iterator().next();
            return Collections.singletonMap(entry.getKey(), entry.getValue());
        }
        HashMap<K, V> copy = new HashMap<K, V>(map);
        return Collections.unmodifiableMap(copy);
    }

    public static String[] split(String separator, int index, String s) {
        return Utils.split(s, 0, index, separator);
    }

    private static String[] split(String s, int fromIndex, int index, String separator) {
        String[] chunks;
        int toIndex = s.indexOf(separator, fromIndex);
        if (toIndex == -1) {
            chunks = new String[index + 1];
            toIndex = s.length();
        } else {
            chunks = Utils.split(s, toIndex + separator.length(), index + 1, separator);
        }
        chunks[index] = s.substring(fromIndex, toIndex);
        return chunks;
    }

    public static String queryEscape(String s) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '%' || ch == '\"' || ch == '_' || ch == '\\') {
                buffer.append('\\').append(ch);
                continue;
            }
            if (ch == '\'') {
                buffer.append("''");
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }
}

