/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.security;

import java.security.SecureRandom;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.security.Token;
import org.exoplatform.web.security.TokenStore;
import org.exoplatform.web.security.security.SecureRandomService;
import org.gatein.common.util.Base64;
import org.picocontainer.Startable;

@Managed
@ManagedDescription(value="Token Store Service")
@NameTemplate(value={@Property(key="service", value="TokenStore"), @Property(key="name", value="{Name}")})
public abstract class AbstractTokenService<T extends Token, K>
implements Startable,
TokenStore {
    protected final Log log = ExoLogger.getLogger(this.getClass());
    protected static final String SERVICE_CONFIG = "service.configuration";
    protected static final String CLEANUP_PERIOD_TIME = "cleanup.period.time";
    public static final int DEFAULT_TOKEN_BYTE_LENGTH = 24;
    protected final int tokenByteLength;
    protected String name;
    protected long validityMillis;
    protected int delayTime = 600;
    private ScheduledExecutorService executor;

    AbstractTokenService(InitParams initParams) {
        List params = initParams.getValuesParam(SERVICE_CONFIG).getValues();
        this.name = (String)params.get(0);
        long configValue = Long.parseLong((String)params.get(1));
        this.validityMillis = TimeoutEnum.valueOf((String)params.get(2)).toMilisecond(configValue);
        this.tokenByteLength = 24;
        ValueParam delayParam = initParams.getValueParam(CLEANUP_PERIOD_TIME);
        if (delayParam != null) {
            this.delayTime = Integer.parseInt(delayParam.getValue());
        }
    }

    public void start() {
        if (this.delayTime > 0) {
            this.executor = Executors.newSingleThreadScheduledExecutor();
            this.executor.scheduleWithFixedDelay(() -> {
                try {
                    PortalContainer container = PortalContainer.getInstance();
                    ExoContainerContext.setCurrentContainer((ExoContainer)container);
                    RequestLifeCycle.begin((ExoContainer)container);
                    try {
                        this.cleanExpiredTokens();
                    }
                    finally {
                        RequestLifeCycle.end();
                    }
                }
                catch (Throwable t) {
                    this.log.warn((Object)"Failed to clean expired tokens", t);
                }
            }, 0L, this.delayTime, TimeUnit.SECONDS);
        }
    }

    public void stop() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    public static <T extends AbstractTokenService<?, ?>> T getInstance(Class<T> classType) {
        PortalContainer container = PortalContainer.getInstance();
        return (T)((AbstractTokenService)classType.cast(container.getComponentInstanceOfType(classType)));
    }

    @Override
    public String validateToken(String stringKey, boolean remove) {
        if (stringKey == null) {
            throw new NullPointerException();
        }
        K tokenKey = this.decodeKey(stringKey);
        try {
            T token = remove ? this.deleteToken(tokenKey) : this.getToken(tokenKey);
            if (token != null) {
                boolean valid;
                boolean bl = valid = token.getExpirationTimeMillis() > System.currentTimeMillis();
                if (valid) {
                    return token.getUsername();
                }
                if (!remove) {
                    this.deleteToken(tokenKey);
                }
            }
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.warn((Object)"Error retrieving token", (Throwable)e);
            }
            this.log.warn((Object)("Error retrieving token. Cause: " + e.getMessage()));
        }
        return null;
    }

    @Managed
    @ManagedDescription(value="Clean all tokens are expired")
    @Impact(value=ImpactType.IDEMPOTENT_WRITE)
    public abstract void cleanExpiredTokens();

    @Managed
    @ManagedDescription(value="Get time for token expiration in seconds")
    public long getValidityTime() {
        return this.validityMillis / 1000L;
    }

    @Managed
    @ManagedDescription(value="The expiration daemon period time in seconds")
    public long getPeriodTime() {
        return this.delayTime;
    }

    @Managed
    @ManagedDescription(value="The token service name")
    public String getName() {
        return this.name;
    }

    public abstract T getToken(K var1);

    public abstract T getToken(K var1, String var2);

    public abstract T deleteToken(K var1);

    public abstract T deleteToken(K var1, String var2);

    protected abstract K decodeKey(String var1);

    @Managed
    @ManagedDescription(value="The number of tokens")
    @Impact(value=ImpactType.READ)
    public abstract long size();

    protected String nextTokenId() {
        return "rememberme" + this.nextRandom();
    }

    protected String nextRandom() {
        byte[] randomBytes = new byte[this.tokenByteLength];
        PortalContainer container = PortalContainer.getInstance();
        SecureRandom random = ((SecureRandomService)container.getComponentInstanceOfType(SecureRandomService.class)).getSecureRandom();
        random.nextBytes(randomBytes);
        return Base64.encodeBytes((byte[])randomBytes, (Base64.EncodingOption)Base64.EncodingOption.USEURLSAFEENCODING);
    }

    private static enum TimeoutEnum {
        SECOND(1000L),
        MINUTE(60000L),
        HOUR(3600000L),
        DAY(86400000L);

        private long multiply;

        private TimeoutEnum(long multiply) {
            this.multiply = multiply;
        }

        public long toMilisecond(long configValue) {
            return configValue * this.multiply;
        }
    }
}

