/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.autoscaling.get_autoscaling_capacity;

import co.elastic.clients.elasticsearch.autoscaling.get_autoscaling_capacity.AutoscalingCapacity;
import co.elastic.clients.elasticsearch.autoscaling.get_autoscaling_capacity.AutoscalingDecider;
import co.elastic.clients.elasticsearch.autoscaling.get_autoscaling_capacity.AutoscalingNode;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class AutoscalingDeciders
implements JsonpSerializable {
    private final AutoscalingCapacity requiredCapacity;
    private final AutoscalingCapacity currentCapacity;
    private final List<AutoscalingNode> currentNodes;
    private final Map<String, AutoscalingDecider> deciders;
    public static final JsonpDeserializer<AutoscalingDeciders> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AutoscalingDeciders::setupAutoscalingDecidersDeserializer);

    private AutoscalingDeciders(Builder builder) {
        this.requiredCapacity = ApiTypeHelper.requireNonNull(builder.requiredCapacity, this, "requiredCapacity");
        this.currentCapacity = ApiTypeHelper.requireNonNull(builder.currentCapacity, this, "currentCapacity");
        this.currentNodes = ApiTypeHelper.unmodifiableRequired(builder.currentNodes, (Object)this, "currentNodes");
        this.deciders = ApiTypeHelper.unmodifiableRequired(builder.deciders, (Object)this, "deciders");
    }

    public static AutoscalingDeciders of(Function<Builder, ObjectBuilder<AutoscalingDeciders>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final AutoscalingCapacity requiredCapacity() {
        return this.requiredCapacity;
    }

    public final AutoscalingCapacity currentCapacity() {
        return this.currentCapacity;
    }

    public final List<AutoscalingNode> currentNodes() {
        return this.currentNodes;
    }

    public final Map<String, AutoscalingDecider> deciders() {
        return this.deciders;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("required_capacity");
        this.requiredCapacity.serialize(generator, mapper);
        generator.writeKey("current_capacity");
        this.currentCapacity.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.currentNodes)) {
            generator.writeKey("current_nodes");
            generator.writeStartArray();
            for (AutoscalingNode autoscalingNode : this.currentNodes) {
                autoscalingNode.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.deciders)) {
            generator.writeKey("deciders");
            generator.writeStartObject();
            for (Map.Entry entry : this.deciders.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((AutoscalingDecider)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupAutoscalingDecidersDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::requiredCapacity, AutoscalingCapacity._DESERIALIZER, "required_capacity");
        op.add(Builder::currentCapacity, AutoscalingCapacity._DESERIALIZER, "current_capacity");
        op.add(Builder::currentNodes, JsonpDeserializer.arrayDeserializer(AutoscalingNode._DESERIALIZER), "current_nodes");
        op.add(Builder::deciders, JsonpDeserializer.stringMapDeserializer(AutoscalingDecider._DESERIALIZER), "deciders");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AutoscalingDeciders> {
        private AutoscalingCapacity requiredCapacity;
        private AutoscalingCapacity currentCapacity;
        private List<AutoscalingNode> currentNodes;
        private Map<String, AutoscalingDecider> deciders;

        public final Builder requiredCapacity(AutoscalingCapacity value) {
            this.requiredCapacity = value;
            return this;
        }

        public final Builder requiredCapacity(Function<AutoscalingCapacity.Builder, ObjectBuilder<AutoscalingCapacity>> fn) {
            return this.requiredCapacity(fn.apply(new AutoscalingCapacity.Builder()).build());
        }

        public final Builder currentCapacity(AutoscalingCapacity value) {
            this.currentCapacity = value;
            return this;
        }

        public final Builder currentCapacity(Function<AutoscalingCapacity.Builder, ObjectBuilder<AutoscalingCapacity>> fn) {
            return this.currentCapacity(fn.apply(new AutoscalingCapacity.Builder()).build());
        }

        public final Builder currentNodes(List<AutoscalingNode> list) {
            this.currentNodes = Builder._listAddAll(this.currentNodes, list);
            return this;
        }

        public final Builder currentNodes(AutoscalingNode value, AutoscalingNode ... values) {
            this.currentNodes = Builder._listAdd(this.currentNodes, value, values);
            return this;
        }

        public final Builder currentNodes(Function<AutoscalingNode.Builder, ObjectBuilder<AutoscalingNode>> fn) {
            return this.currentNodes(fn.apply(new AutoscalingNode.Builder()).build(), new AutoscalingNode[0]);
        }

        public final Builder deciders(Map<String, AutoscalingDecider> map) {
            this.deciders = Builder._mapPutAll(this.deciders, map);
            return this;
        }

        public final Builder deciders(String key, AutoscalingDecider value) {
            this.deciders = Builder._mapPut(this.deciders, key, value);
            return this;
        }

        public final Builder deciders(String key, Function<AutoscalingDecider.Builder, ObjectBuilder<AutoscalingDecider>> fn) {
            return this.deciders(key, fn.apply(new AutoscalingDecider.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AutoscalingDeciders build() {
            this._checkSingleUse();
            return new AutoscalingDeciders(this);
        }
    }
}

