/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.xml.stax.writer.formatting;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.gatein.common.xml.stax.writer.formatting.XmlStreamingFormatter;

public class SimpleFormatter
implements XmlStreamingFormatter {
    public static final int DEFAULT_INDENT_SIZE = 3;
    public static final char DEFAULT_INDENT_CHAR = ' ';
    public static final String DEFAULT_NEWLINE;
    private String indentSequence;
    private String newline;
    private int depth = 0;
    private int previousEvent;

    public SimpleFormatter() {
        this(' ', 3, DEFAULT_NEWLINE);
    }

    public SimpleFormatter(char indentCharacter, int indentSize, String newline) {
        if (newline == null) {
            throw new IllegalArgumentException("newline cannot be null");
        }
        this.newline = newline;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indentSize; ++i) {
            sb.append(indentCharacter);
        }
        this.indentSequence = sb.toString();
    }

    @Override
    public void before(XMLStreamWriter writer, int event) throws XMLStreamException {
        switch (event) {
            case 1: {
                ++this.depth;
                this.nl(writer);
                this.indent(writer);
                break;
            }
            case 2: {
                if (this.previousEvent == 2) {
                    this.nl(writer);
                    this.indent(writer);
                }
                --this.depth;
            }
        }
    }

    @Override
    public void after(XMLStreamWriter writer, int event) throws XMLStreamException {
        this.previousEvent = event;
    }

    private void nl(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters(this.newline);
    }

    private void indent(XMLStreamWriter writer) throws XMLStreamException {
        for (int i = 0; i < this.depth - 1; ++i) {
            writer.writeCharacters(this.indentSequence);
        }
    }

    static {
        String newline = null;
        try {
            newline = System.getProperty("line.separator");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (newline == null) {
            newline = "\n";
        }
        DEFAULT_NEWLINE = newline;
    }
}

