/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin;

import java.util.ArrayList;
import java.util.HashSet;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class EditActivityPlugin
extends BaseNotificationPlugin {
    public static final String ID = "EditActivityPlugin";
    protected boolean isSubComment = false;

    public EditActivityPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return ID;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        ExoSocialActivity activity = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
        String spaceId = activity.getSpaceId();
        HashSet<String> receivers = new HashSet<String>();
        if (activity.getStreamOwner() != null) {
            Utils.sendToStreamOwner(receivers, activity.getStreamOwner(), activity.getPosterId());
        }
        Utils.sendToCommeters(receivers, activity.getCommentedIds(), activity.getPosterId(), spaceId);
        Utils.sendToActivityPoster(receivers, activity.getPosterId(), activity.getPosterId(), spaceId);
        String poster = Utils.getUserId(activity.getUserId());
        return NotificationInfo.instance().to(new ArrayList<String>(receivers)).setFrom(poster).setSpaceId(spaceId == null ? 0L : Long.parseLong(spaceId)).with(SocialNotificationUtils.ACTIVITY_ID.getKey(), activity.getId()).with(SocialNotificationUtils.POSTER.getKey(), poster).key(this.getId());
    }

    public boolean isValid(NotificationContext ctx) {
        ExoSocialActivity activity = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
        Identity spaceIdentity = Utils.getIdentityManager().getOrCreateSpaceIdentity(activity.getStreamOwner());
        return spaceIdentity == null || !activity.getPosterId().equals(spaceIdentity.getId());
    }
}

