/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.plugin.gamification;

import io.meeds.gamification.service.RuleService;
import io.meeds.portal.permlink.model.PermanentLinkObject;
import io.meeds.portal.permlink.service.PermanentLinkService;
import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.plugin.PwaNotificationPlugin;
import io.meeds.social.translation.service.TranslationService;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Profile(value={"gamification"})
@Component
public class GamificationActionPublishedPwaNotificationPlugin
implements PwaNotificationPlugin {
    private static final String TITLE_LABEL_KEY = "pwa.notification.GamificationActionPublishedNotification.title";
    @Autowired
    private ResourceBundleService resourceBundleService;
    @Autowired
    private PermanentLinkService permanentLinkService;
    @Autowired
    private RuleService ruleService;
    @Autowired
    private TranslationService translationService;

    public String getId() {
        return "GamificationActionPublishedNotification";
    }

    public PwaNotificationMessage process(NotificationInfo notification, LocaleConfig localeConfig) {
        PwaNotificationMessage notificationMessage = new PwaNotificationMessage();
        notificationMessage.setTitle(this.resourceBundleService.getSharedString(TITLE_LABEL_KEY, localeConfig.getLocale()));
        long ruleId = Long.parseLong(notification.getValueOwnerParameter("RULE_ID"));
        String ruleTitle = this.translationService.getTranslationLabel("rule", ruleId, "title", localeConfig.getLocale());
        if (StringUtils.isBlank((CharSequence)ruleTitle)) {
            ruleTitle = this.ruleService.findRuleById(ruleId).getTitle();
        }
        notificationMessage.setBody(ruleTitle);
        String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
        notificationMessage.setUrl(this.permanentLinkService.getPermanentLink(new PermanentLinkObject("activity", activityId)));
        return notificationMessage;
    }
}

