/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.dao;

import jakarta.persistence.TypedQuery;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.exoplatform.wiki.jpa.dao.WikiBaseDAO;
import org.exoplatform.wiki.jpa.entity.PageMoveEntity;
import org.exoplatform.wiki.model.WikiType;

public class PageMoveDAO
extends WikiBaseDAO<PageMoveEntity, Long> {
    private static final String PAGE_ID_PARAM = "pageId";

    public List<PageMoveEntity> findInPageMoves(String wikiType, String wikiOwner, String pageName) {
        if (wikiType.toUpperCase().equals(WikiType.GROUP.name())) {
            wikiOwner = this.validateGroupWikiOwner(wikiOwner);
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("wikiPageMove.getPreviousPage", PageMoveEntity.class).setParameter("wikiType", (Object)wikiType).setParameter("wikiOwner", (Object)wikiOwner).setParameter("pageName", (Object)pageName);
        return query.getResultList();
    }

    public List<PageMoveEntity> findMovesByPage(Long pageId) {
        return this.getEntityManager().createNamedQuery("wikiPageMove.findMovesByPage", PageMoveEntity.class).setParameter(PAGE_ID_PARAM, (Object)pageId).getResultList();
    }

    public void deletePageMoves(long pageId) {
        List<PageMoveEntity> moves = this.findMovesByPage(pageId);
        if (CollectionUtils.isNotEmpty(moves)) {
            moves.forEach(arg_0 -> ((PageMoveDAO)this).delete(arg_0));
        }
    }
}

