/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.Retriever;
import co.elastic.clients.elasticsearch._types.RetrieverBase;
import co.elastic.clients.elasticsearch._types.RetrieverVariant;
import co.elastic.clients.elasticsearch._types.SpecifiedDocument;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PinnedRetriever
extends RetrieverBase
implements RetrieverVariant {
    private final Retriever retriever;
    private final List<String> ids;
    private final List<SpecifiedDocument> docs;
    private final int rankWindowSize;
    public static final JsonpDeserializer<PinnedRetriever> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PinnedRetriever::setupPinnedRetrieverDeserializer);

    private PinnedRetriever(Builder builder) {
        super(builder);
        this.retriever = ApiTypeHelper.requireNonNull(builder.retriever, this, "retriever");
        this.ids = ApiTypeHelper.unmodifiable(builder.ids);
        this.docs = ApiTypeHelper.unmodifiable(builder.docs);
        this.rankWindowSize = ApiTypeHelper.requireNonNull(builder.rankWindowSize, (Object)this, "rankWindowSize", 0);
    }

    public static PinnedRetriever of(Function<Builder, ObjectBuilder<PinnedRetriever>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Retriever.Kind _retrieverKind() {
        return Retriever.Kind.Pinned;
    }

    public final Retriever retriever() {
        return this.retriever;
    }

    public final List<String> ids() {
        return this.ids;
    }

    public final List<SpecifiedDocument> docs() {
        return this.docs;
    }

    public final int rankWindowSize() {
        return this.rankWindowSize;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("retriever");
        this.retriever.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.ids)) {
            generator.writeKey("ids");
            generator.writeStartArray();
            for (String string : this.ids) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.docs)) {
            generator.writeKey("docs");
            generator.writeStartArray();
            for (SpecifiedDocument specifiedDocument : this.docs) {
                specifiedDocument.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("rank_window_size");
        generator.write(this.rankWindowSize);
    }

    protected static void setupPinnedRetrieverDeserializer(ObjectDeserializer<Builder> op) {
        RetrieverBase.setupRetrieverBaseDeserializer(op);
        op.add(Builder::retriever, Retriever._DESERIALIZER, "retriever");
        op.add(Builder::ids, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ids");
        op.add(Builder::docs, JsonpDeserializer.arrayDeserializer(SpecifiedDocument._DESERIALIZER), "docs");
        op.add(Builder::rankWindowSize, JsonpDeserializer.integerDeserializer(), "rank_window_size");
    }

    public static class Builder
    extends RetrieverBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PinnedRetriever> {
        private Retriever retriever;
        @Nullable
        private List<String> ids;
        @Nullable
        private List<SpecifiedDocument> docs;
        private Integer rankWindowSize;

        public final Builder retriever(Retriever value) {
            this.retriever = value;
            return this;
        }

        public final Builder retriever(Function<Retriever.Builder, ObjectBuilder<Retriever>> fn) {
            return this.retriever(fn.apply(new Retriever.Builder()).build());
        }

        public final Builder retriever(RetrieverVariant value) {
            this.retriever = value._toRetriever();
            return this;
        }

        public final Builder ids(List<String> list) {
            this.ids = Builder._listAddAll(this.ids, list);
            return this;
        }

        public final Builder ids(String value, String ... values) {
            this.ids = Builder._listAdd(this.ids, value, values);
            return this;
        }

        public final Builder docs(List<SpecifiedDocument> list) {
            this.docs = Builder._listAddAll(this.docs, list);
            return this;
        }

        public final Builder docs(SpecifiedDocument value, SpecifiedDocument ... values) {
            this.docs = Builder._listAdd(this.docs, value, values);
            return this;
        }

        public final Builder docs(Function<SpecifiedDocument.Builder, ObjectBuilder<SpecifiedDocument>> fn) {
            return this.docs(fn.apply(new SpecifiedDocument.Builder()).build(), new SpecifiedDocument[0]);
        }

        public final Builder rankWindowSize(int value) {
            this.rankWindowSize = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PinnedRetriever build() {
            this._checkSingleUse();
            return new PinnedRetriever(this);
        }
    }
}

