/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.category.plugin;

import io.meeds.social.category.plugin.CategoryPlugin;
import io.meeds.social.category.service.CategoryLinkService;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;

public class DefaultCategoryPlugin
implements CategoryPlugin {
    public final PortalContainer container;
    public final String objectType;
    private UserACL userAcl;
    private CategoryLinkService categoryLinkService;

    public DefaultCategoryPlugin(PortalContainer container, String objectType) {
        this.container = container;
        this.objectType = objectType;
    }

    public String getType() {
        return this.objectType;
    }

    public boolean canAccess(String newsId, String username) {
        return this.getUserAcl().hasAccessPermission(this.objectType, newsId, username);
    }

    public boolean canEdit(String newsId, String username) {
        return this.getUserAcl().hasEditPermission(this.objectType, newsId, username);
    }

    public List<Long> getCategoryIds() {
        return this.getCategoryLinkService().getLinkedIds(this.objectType);
    }

    public UserACL getUserAcl() {
        if (this.userAcl == null) {
            this.userAcl = (UserACL)this.container.getComponentInstanceOfType(UserACL.class);
        }
        return this.userAcl;
    }

    public CategoryLinkService getCategoryLinkService() {
        if (this.categoryLinkService == null) {
            this.categoryLinkService = (CategoryLinkService)this.container.getComponentInstanceOfType(CategoryLinkService.class);
        }
        return this.categoryLinkService;
    }
}

