/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import org.exoplatform.web.controller.router.PercentEncoding;
import org.exoplatform.web.url.MimeType;

public final class URIWriter {
    private static final Map<MimeType, String> AMP_MAP = new EnumMap<MimeType, String>(MimeType.class);
    private MimeType mimeType;
    private Appendable appendable;
    private boolean questionMarkDone;
    private String amp;

    public URIWriter(Appendable appendable, MimeType mimeType) throws NullPointerException {
        if (appendable == null) {
            throw new NullPointerException("No null appendable accepted");
        }
        this.appendable = appendable;
        this.mimeType = mimeType;
    }

    public URIWriter(Appendable appendable) throws NullPointerException {
        this(appendable, null);
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(MimeType mimeType) {
        this.mimeType = mimeType;
    }

    public void append(char c) throws IOException {
        this.appendable.append(c);
    }

    public void append(String s) throws IOException {
        this.appendable.append(s);
    }

    public void appendSegment(char c) throws IllegalStateException, IOException {
        if (this.questionMarkDone) {
            throw new IllegalStateException("Query separator already written");
        }
        PercentEncoding.PATH_SEGMENT.encode(c, this.appendable);
    }

    public void appendSegment(String s) throws NullPointerException, IllegalStateException, IOException {
        if (s == null) {
            throw new NullPointerException("No null path accepted");
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            this.appendSegment(c);
        }
    }

    public void appendQueryParameter(String parameterName, String paramaterValue) throws NullPointerException, IOException {
        if (parameterName == null) {
            throw new NullPointerException("No null parameter name accepted");
        }
        if (paramaterValue == null) {
            throw new NullPointerException("No null parameter value accepted");
        }
        if (this.amp == null) {
            MimeType mt = this.mimeType;
            if (mt == null) {
                mt = MimeType.XHTML;
            }
            this.amp = AMP_MAP.get((Object)mt);
        }
        this.appendable.append(this.questionMarkDone ? this.amp : "?");
        PercentEncoding.QUERY_PARAM.encode(parameterName, this.appendable);
        this.appendable.append('=');
        PercentEncoding.QUERY_PARAM.encode(paramaterValue, this.appendable);
        this.questionMarkDone = true;
    }

    public void reset(Appendable appendable) {
        this.appendable = appendable;
        this.questionMarkDone = false;
    }

    static {
        AMP_MAP.put(MimeType.XHTML, "&amp;");
        AMP_MAP.put(MimeType.PLAIN, "&");
    }
}

