/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import jakarta.servlet.ServletContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.cache.future.FutureMap;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.portal.resource.AbstractResourceService;
import org.exoplatform.portal.resource.CachedStylesheet;
import org.exoplatform.portal.resource.CommentBlockHandler;
import org.exoplatform.portal.resource.GateInSkinConfigDeployer;
import org.exoplatform.portal.resource.Resource;
import org.exoplatform.portal.resource.ResourceRenderer;
import org.exoplatform.portal.resource.SimpleSkin;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinKey;
import org.exoplatform.portal.resource.SkinVisitor;
import org.exoplatform.portal.resource.SkipCommentReader;
import org.exoplatform.portal.resource.compressor.ResourceCompressor;
import org.exoplatform.portal.resource.compressor.ResourceCompressorException;
import org.exoplatform.portal.resource.compressor.ResourceType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.web.ControllerContext;
import org.gatein.portal.controller.resource.ResourceRequestHandler;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.WebApp;
import org.gatein.wci.WebAppListener;
import org.picocontainer.Startable;

@Managed
@NameTemplate(value={@Property(key="view", value="portal"), @Property(key="service", value="management"), @Property(key="type", value="skin")})
@ManagedDescription(value="Skin service")
@RESTEndpoint(path="skinservice")
public class SkinService
extends AbstractResourceService
implements Startable {
    protected static final Log LOG = ExoLogger.getLogger((String)"portal.SkinService");
    private static final String LEFT_P = "\\(";
    private static final String RIGHT_P = "\\)";
    private static final Pattern BACKGROUND_PATTERN = Pattern.compile("(background[^;])+([^;]*;)");
    private static final Pattern FONT_FACE_PATTERN = Pattern.compile("(src[^;])+([^;]*;)");
    private static final Pattern URL_PATTERN = Pattern.compile("(url\\(['\"]?)([^'\";\\)]+)(['\"]?\\))");
    private static final Pattern LT = Pattern.compile(".*/\\*.*orientation=lt.*\\*/.*");
    private static final Pattern RT = Pattern.compile(".*/\\*.*orientation=rt.*\\*/.*");
    public static final String DEFAULT_SKIN_PARAM_NAME = "skin.default";
    private static final String DEFAULT_SKIN = "Enterprise";
    public static final String CUSTOM_MODULE_ID = "customModule";
    public static final long MAX_AGE;
    private final WebAppListener deployer;
    private final Map<SkinKey, SkinConfig> portalSkins;
    private final Map<SkinKey, SkinConfig> customPortalSkins;
    private final Map<SkinKey, SkinConfig> skinConfigs;
    private final HashSet<String> availableSkins;
    @Deprecated(forRemoval=true, since="7.0")
    private final FutureMap<String, CachedStylesheet, SkinContext> ltCache;
    @Deprecated(forRemoval=true, since="7.0")
    private final FutureMap<String, CachedStylesheet, SkinContext> rtCache;
    private final Map<String, Set<String>> portletThemes;
    private Map<Integer, File> files = new ConcurrentHashMap<Integer, File>();
    private String defaultSkin;
    final String portalContainerName;
    final String id = Long.toString(System.currentTimeMillis());
    private boolean developing;

    public SkinService(InitParams initParams, ExoContainerContext context, ResourceCompressor compressor) {
        super(compressor);
        ValueParam defaultSkinValueParam;
        Loader<String, CachedStylesheet, SkinContext> loader = new Loader<String, CachedStylesheet, SkinContext>(){

            public CachedStylesheet retrieve(SkinContext context, String key) throws Exception {
                Resource skin = SkinService.this.getCSSResource(key, key);
                if (skin == null) {
                    return null;
                }
                StringBuffer sb = new StringBuffer();
                try (Reader sourceReader = skin.read();){
                    SkinService.this.processCSSRecursively(skin.getContextPath() + skin.getParentPath(), sourceReader, sb, context.orientation);
                }
                String css = sb.toString();
                if (SkinService.this.compressor.isSupported(ResourceType.STYLESHEET)) {
                    css = SkinService.this.compressor.compress(css, ResourceType.STYLESHEET);
                }
                return new CachedStylesheet(css);
            }
        };
        this.portalSkins = new LinkedHashMap<SkinKey, SkinConfig>();
        this.customPortalSkins = new LinkedHashMap<SkinKey, SkinConfig>();
        this.skinConfigs = new LinkedHashMap<SkinKey, SkinConfig>();
        this.availableSkins = new HashSet();
        this.ltCache = new FutureMap((Loader)loader);
        this.rtCache = new FutureMap((Loader)loader);
        this.portletThemes = new HashMap<String, Set<String>>();
        this.portalContainerName = context.getPortalContainerName();
        this.deployer = new GateInSkinConfigDeployer(this.portalContainerName, this);
        this.defaultSkin = DEFAULT_SKIN;
        if (initParams != null && (defaultSkinValueParam = initParams.getValueParam(DEFAULT_SKIN_PARAM_NAME)) != null && StringUtils.isNotEmpty((CharSequence)defaultSkinValueParam.getValue())) {
            this.defaultSkin = defaultSkinValueParam.getValue();
        }
    }

    public void start() {
        this.developing = PropertyManager.isDevelopping();
        ServletContainerFactory.getServletContainer().addWebAppListener(this.deployer);
    }

    public void stop() {
        ServletContainerFactory.getServletContainer().removeWebAppListener(this.deployer);
    }

    public void initData() {
        long start = System.currentTimeMillis();
        LOG.info((Object)"Start caching CSS data");
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(() -> {
            ExoContainerContext.setCurrentContainer((ExoContainer)PortalContainer.getInstance());
            try {
                this.skinConfigs.values().parallelStream().forEach(this::initSkinModuleCache);
            }
            catch (Throwable throwable) {
                LOG.info("End caching CSS data within {}ms", new Object[]{System.currentTimeMillis() - start});
                ExoContainerContext.setCurrentContainer(null);
                executorService.shutdownNow();
                throw throwable;
            }
            LOG.info("End caching CSS data within {}ms", new Object[]{System.currentTimeMillis() - start});
            ExoContainerContext.setCurrentContainer(null);
            executorService.shutdownNow();
        });
    }

    @Managed
    @ManagedDescription(value="The list of registered skins identifiers")
    public String[] getSkinList() {
        ArrayList<String> availableSkin = new ArrayList<String>();
        for (String skin : this.availableSkins) {
            availableSkin.add(skin);
        }
        Collections.sort(availableSkin);
        return availableSkin.toArray(new String[availableSkin.size()]);
    }

    @Managed
    @ManagedDescription(value="Reload all skins")
    @Impact(value=ImpactType.WRITE)
    public void reloadSkins() {
        this.ltCache.clear();
        this.rtCache.clear();
        this.files.clear();
    }

    public void invalidateCachedSkin(String path) {
        this.ltCache.remove((Serializable)((Object)path));
        this.rtCache.remove((Serializable)((Object)path));
    }

    public String getSkinModuleContent(String fileWebAppPath, int fileContentHash, Orientation orientation, boolean compress) throws IOException {
        if (this.developing) {
            return this.getSkinModuleFileContent(fileWebAppPath, orientation, compress);
        }
        File cssFile = this.files.computeIfAbsent(Objects.hash(fileContentHash, orientation, compress), k -> {
            try {
                return this.getSkinModuleFileNoCache(fileWebAppPath, orientation, compress);
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Error while reading file %s content", fileWebAppPath), e);
            }
        });
        if (cssFile == null) {
            return null;
        }
        return FileUtils.readFileToString((File)cssFile, (Charset)StandardCharsets.UTF_8);
    }

    public String getSkinModuleFileContent(String fileWebAppPath) throws IOException {
        ServletContext servletContext = Collections.unmodifiableCollection(this.contexts.values()).stream().filter(c -> fileWebAppPath.startsWith(c.getContextPath() + "/")).map(WebApp::getServletContext).findFirst().orElse(null);
        if (servletContext == null) {
            throw new IllegalStateException("Can't retrieve ServletContext of path " + fileWebAppPath);
        }
        try (InputStream inputStream = servletContext.getResourceAsStream(fileWebAppPath.replaceFirst(servletContext.getContextPath(), ""));){
            String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    public String getDefaultSkin() {
        if (!this.availableSkins.contains(this.defaultSkin)) {
            LOG.warn("Skin \"{}\" does not exist, switching to skin \"Default\" as the default skin", new Object[]{this.defaultSkin});
            this.defaultSkin = DEFAULT_SKIN;
        }
        return this.defaultSkin;
    }

    public void addPortalSkin(String module, String skinName, String cssPath) {
        this.addPortalSkin(module, skinName, cssPath, Integer.MAX_VALUE, false);
    }

    public void addPortalSkin(String module, String skinName, String cssPath, boolean overwrite) {
        this.addPortalSkin(module, skinName, cssPath, Integer.MAX_VALUE, overwrite);
    }

    public void addPortalSkin(String module, String skinName, String cssPath, int priority, boolean overwrite) {
        this.availableSkins.add(skinName);
        SkinKey key = new SkinKey(module, skinName);
        SkinConfig skinConfig = this.portalSkins.get(key);
        if (skinConfig == null || overwrite) {
            if (priority < 0) {
                priority = Integer.MAX_VALUE;
            }
            skinConfig = new SimpleSkin(module, skinName, cssPath, priority);
            if (module.startsWith(CUSTOM_MODULE_ID)) {
                skinConfig.setType("custom-skin");
                this.customPortalSkins.put(key, skinConfig);
            } else {
                skinConfig.setType("portal-skin");
                this.portalSkins.put(key, skinConfig);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding Portal skin : Bind " + String.valueOf(key) + " to " + String.valueOf(skinConfig)));
            }
        }
    }

    public SkinConfig addPortalSkin(String module, String skinName, String cssPath, int priority, boolean overwrite, boolean filtered) {
        this.availableSkins.add(skinName);
        SkinKey key = new SkinKey(module, skinName);
        SkinConfig skinConfig = this.portalSkins.get(key);
        if (skinConfig == null || overwrite) {
            if (priority < 0) {
                priority = Integer.MAX_VALUE;
            }
            SimpleSkin skin = new SimpleSkin(module, skinName, cssPath, priority, filtered);
            if (module.startsWith(CUSTOM_MODULE_ID)) {
                skin.setType("custom-skin");
                this.customPortalSkins.put(key, skin);
            } else {
                skin.setType("portal-skin");
                this.portalSkins.put(key, skin);
            }
        }
        return skinConfig;
    }

    public void addSkin(String module, String skinName, String cssPath) {
        this.addSkin(module, skinName, cssPath, Integer.MAX_VALUE, false);
    }

    public void addSkin(String module, String skinName, String cssPath, boolean overwrite) {
        this.addSkin(module, skinName, cssPath, Integer.MAX_VALUE, overwrite);
    }

    public void addSkin(String module, String skinName, String cssPath, int priority, boolean overwrite) {
        this.addSkin(module, skinName, cssPath, priority, overwrite, null);
    }

    public SkinConfig addSkin(String module, String skinName, String cssPath, int priority, boolean overwrite, List<String> additionalModules) {
        this.availableSkins.add(skinName);
        SkinKey key = new SkinKey(module, skinName);
        SkinConfig skinConfig = this.skinConfigs.get(key);
        if (skinConfig == null || overwrite) {
            if (priority < 0) {
                priority = Integer.MAX_VALUE;
            }
            skinConfig = new SimpleSkin(module, skinName, cssPath, priority, additionalModules);
            skinConfig.setType("portlet-skin");
            this.skinConfigs.put(key, skinConfig);
        } else {
            if (CollectionUtils.isNotEmpty(additionalModules)) {
                skinConfig.getAdditionalModules().addAll(additionalModules);
            }
            if (skinConfig.getCSSPath() == null && cssPath != null) {
                skinConfig.setType("portlet-skin");
                skinConfig.setCSSPath(cssPath);
                skinConfig.setPriority(priority);
            }
        }
        return skinConfig;
    }

    public void addTheme(String categoryName, List<String> themesName) {
        this.portletThemes.computeIfAbsent(categoryName, k -> new HashSet()).addAll(themesName);
    }

    public Set<String> getAvailableSkinNames() {
        return this.availableSkins;
    }

    @Deprecated(forRemoval=true, since="7.0")
    public boolean renderCSS(ControllerContext context, ResourceRenderer renderer, boolean compress) throws IOException {
        Orientation orientation = this.getOrientation(context);
        String resource = "/" + context.getParameter(ResourceRequestHandler.RESOURCE_QN) + ".css";
        if (!compress) {
            StringBuffer sb = new StringBuffer();
            Resource skin = this.getCSSResource(resource, resource);
            if (skin != null) {
                try (Reader sourceReader = skin.read();){
                    this.processCSSRecursively(skin.getContextPath() + skin.getParentPath(), sourceReader, sb, orientation);
                }
                byte[] bytes = sb.toString().getBytes(StandardCharsets.UTF_8);
                renderer.setExpiration(MAX_AGE);
                if (context.getResponse() != null) {
                    context.getResponse().setContentLength(bytes.length);
                }
                renderer.getOutput().write(bytes);
                return true;
            }
        } else {
            CachedStylesheet cachedCss = (CachedStylesheet)this.getCache(orientation).get((Object)new SkinContext(context, orientation), (Object)resource);
            if (cachedCss != null) {
                renderer.setExpiration(MAX_AGE);
                if (context.getResponse() != null) {
                    context.getResponse().setContentLength(cachedCss.getLength());
                }
                cachedCss.writeTo(renderer.getOutput());
                return true;
            }
        }
        return false;
    }

    public Collection<SkinConfig> getPortalSkins(String skinName) {
        if (StringUtils.isEmpty((CharSequence)skinName)) {
            skinName = this.getDefaultSkin();
        }
        Set<SkinKey> keys = this.portalSkins.keySet();
        ArrayList<SkinConfig> skins = new ArrayList<SkinConfig>();
        for (SkinKey key : keys) {
            SkinConfig skinConfig;
            if (!key.getName().equals(skinName) || (skinConfig = this.portalSkins.get(key)).isFiltered()) continue;
            skins.add(skinConfig);
        }
        Collections.sort(skins, (o1, o2) -> o1.getCSSPriority() - o2.getCSSPriority());
        return skins;
    }

    public Collection<SkinConfig> findSkins(SkinVisitor visitor) {
        return visitor.getSkins(this.portalSkins.entrySet(), this.skinConfigs.entrySet());
    }

    public Collection<SkinConfig> getCustomPortalSkins(String skinName) {
        if (StringUtils.isEmpty((CharSequence)skinName)) {
            skinName = this.getDefaultSkin();
        }
        Set<SkinKey> keys = this.customPortalSkins.keySet();
        ArrayList<SkinConfig> skins = new ArrayList<SkinConfig>();
        for (SkinKey key : keys) {
            SkinConfig skinConfig;
            if (!key.getName().equals(skinName) || (skinConfig = this.customPortalSkins.get(key)).isFiltered()) continue;
            skins.add(skinConfig);
        }
        Collections.sort(skins, (o1, o2) -> o1.getCSSPriority() - o2.getCSSPriority());
        return skins;
    }

    public Map<String, Set<String>> getPortletThemes() {
        return this.portletThemes;
    }

    public SkinConfig getSkin(String module, String skinName) {
        SkinConfig config;
        if (StringUtils.isBlank((CharSequence)skinName)) {
            skinName = this.getDefaultSkin();
        }
        if ((config = this.skinConfigs.get(new SkinKey(module, skinName))) == null) {
            config = this.skinConfigs.get(new SkinKey(module, this.getDefaultSkin()));
        }
        return config;
    }

    public SkinConfig getPortalSkin(String module, String skinName) {
        SkinConfig portalSkin = this.getPortalSkin(module, skinName, this.portalSkins);
        if (portalSkin == null) {
            portalSkin = this.getPortalSkin(module, skinName, this.customPortalSkins);
        }
        return portalSkin;
    }

    @Deprecated
    public long getLastModified(ControllerContext context) {
        String resource = "/" + context.getParameter(ResourceRequestHandler.RESOURCE_QN) + ".css";
        Orientation orientation = this.getOrientation(context);
        CachedStylesheet cachedCSS = (CachedStylesheet)this.getCache(orientation).get((Object)new SkinContext(context, orientation), (Object)resource);
        if (cachedCSS == null) {
            return System.currentTimeMillis();
        }
        return cachedCSS.getLastModified();
    }

    public void removeSkin(SkinKey key) {
        if (key == null) {
            return;
        }
        SkinConfig remove = this.skinConfigs.remove(key);
        if (remove != null && StringUtils.isNotBlank((CharSequence)remove.getCSSPath())) {
            this.invalidateCachedSkin(remove.getCSSPath());
        }
    }

    public void removePortalSkin(String module, String skinName) {
        SkinKey key = StringUtils.isBlank((CharSequence)skinName) ? new SkinKey(module, this.getDefaultSkin()) : new SkinKey(module, skinName);
        this.removePortalSkin(key);
    }

    public void removePortalSkin(SkinKey key) {
        if (key == null) {
            return;
        }
        SkinConfig remove = null;
        remove = key.getModule().startsWith(CUSTOM_MODULE_ID) ? this.customPortalSkins.remove(key) : this.portalSkins.remove(key);
        if (remove != null && StringUtils.isNotBlank((CharSequence)remove.getCSSPath())) {
            this.invalidateCachedSkin(remove.getCSSPath());
        }
    }

    public void removeSkins(List<SkinKey> keys) {
        if (keys == null) {
            return;
        }
        for (SkinKey key : keys) {
            this.removeSkin(key);
        }
    }

    public void removeSupportedSkin(String skinName) {
        this.availableSkins.remove(skinName);
    }

    public int size() {
        return this.skinConfigs.size();
    }

    public void processCSSRecursively(String basePath, Reader sourceReader, Appendable appendable, Orientation orientation) throws IOException {
        try (SkipCommentReader reader = new SkipCommentReader(sourceReader, new CommentBlockHandler.OrientationCommentBlockHandler());){
            String line = ((BufferedReader)reader).readLine();
            while (line != null) {
                line = this.proccessOrientation(line, orientation);
                line = this.processURL(BACKGROUND_PATTERN, line, basePath);
                if (StringUtils.isNotBlank((CharSequence)(line = this.processURL(FONT_FACE_PATTERN, line, basePath)))) {
                    appendable.append(line);
                }
                if ((line = ((BufferedReader)reader).readLine()) == null) continue;
                appendable.append("\n");
            }
        }
    }

    private Resource getCSSResource(String cssPath, String outerCssFile) {
        Resource resource = this.mainResolver.resolve(cssPath);
        if (resource == null && LOG.isErrorEnabled()) {
            String logMessage;
            if (!cssPath.equals(outerCssFile)) {
                int lastIndexOfSlash = cssPath.lastIndexOf(47);
                String loadedCssFile = lastIndexOfSlash >= 0 ? cssPath.substring(lastIndexOfSlash + 1) : cssPath;
                logMessage = "Invalid <CSS FILE> configuration, please check the @import url(" + loadedCssFile + ") in " + outerCssFile + " , SkinService could not load the skin " + cssPath;
            } else {
                logMessage = "Not found <CSS FILE>, the path " + cssPath + " is invalid, SkinService could not load the skin " + cssPath;
            }
            LOG.error((Object)logMessage);
        }
        return resource;
    }

    private String processURL(Pattern pattern, String line, String basePath) {
        Matcher patternMatcher = pattern.matcher(line);
        StringBuffer tmpBuilder = new StringBuffer();
        while (patternMatcher.find()) {
            Matcher urlMatcher = URL_PATTERN.matcher(patternMatcher.group());
            StringBuffer tmpURL = new StringBuffer();
            while (urlMatcher.find()) {
                if (urlMatcher.group(2).startsWith("\"/") || urlMatcher.group(2).startsWith("'/") || urlMatcher.group(2).startsWith("/")) continue;
                StringBuilder urlBuilder = new StringBuilder();
                urlBuilder.append(urlMatcher.group(1));
                urlBuilder.append(basePath);
                urlBuilder.append(urlMatcher.group(2));
                urlBuilder.append(urlMatcher.group(3));
                urlMatcher.appendReplacement(tmpURL, urlBuilder.toString());
            }
            urlMatcher.appendTail(tmpURL);
            patternMatcher.appendReplacement(tmpBuilder, tmpURL.toString());
        }
        patternMatcher.appendTail(tmpBuilder);
        return tmpBuilder.toString();
    }

    private String proccessOrientation(String line, Orientation orientation) {
        Pattern orientationPattern = orientation == Orientation.LT ? RT : LT;
        Matcher matcher = orientationPattern.matcher(line);
        StringBuffer tmpBuilder = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(tmpBuilder, "");
        }
        matcher.appendTail(tmpBuilder);
        return tmpBuilder.toString();
    }

    @Deprecated(forRemoval=true, since="7.0")
    private FutureMap<String, CachedStylesheet, SkinContext> getCache(Orientation orientation) {
        return orientation == Orientation.RT ? this.rtCache : this.ltCache;
    }

    private Orientation getOrientation(ControllerContext context) {
        if ("rt".equals(context.getParameter(ResourceRequestHandler.ORIENTATION_QN))) {
            return Orientation.RT;
        }
        return Orientation.LT;
    }

    private SkinConfig getPortalSkin(String module, String skinName, Map<SkinKey, SkinConfig> portalSkins) {
        SkinConfig config;
        if (StringUtils.isEmpty((CharSequence)skinName)) {
            skinName = this.getDefaultSkin();
        }
        if ((config = portalSkins.get(new SkinKey(module, skinName))) == null) {
            config = portalSkins.get(new SkinKey(module, this.getDefaultSkin()));
        }
        return config;
    }

    private File getSkinModuleFileNoCache(String fileWebAppPath, Orientation orientation, boolean compress) throws IOException {
        String fileContent = this.getSkinModuleFileContent(fileWebAppPath, orientation, compress);
        if (fileContent != null) {
            try {
                File file = File.createTempFile("stylesheet_cache_", fileWebAppPath.substring(fileWebAppPath.lastIndexOf("/") + 1));
                FileUtils.write((File)file, (CharSequence)fileContent, (Charset)StandardCharsets.UTF_8);
                file.deleteOnExit();
                return file;
            }
            catch (Exception e) {
                LOG.error("Error while processing CSS file {}", new Object[]{fileWebAppPath, e});
                return null;
            }
        }
        return null;
    }

    private String getSkinModuleFileContent(String fileWebAppPath, Orientation orientation, boolean compress) throws IOException {
        String fileContent = this.getSkinModuleFileContent(fileWebAppPath);
        try (StringReader sourceReader = new StringReader(fileContent);){
            StringBuilder sb = new StringBuilder();
            this.processCSSRecursively(fileWebAppPath, sourceReader, sb, orientation);
            fileContent = sb.toString().replaceAll("(\n\n+)", "\n");
        }
        if (compress && this.compressor.isSupported(ResourceType.STYLESHEET)) {
            try {
                fileContent = this.compressor.compress(fileContent, ResourceType.STYLESHEET);
            }
            catch (ResourceCompressorException e) {
                LOG.warn("Error while compressing CSS file {}. Retrieve it as is", new Object[]{fileWebAppPath, e});
            }
        }
        return fileContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSkinModuleCache(SkinConfig skin) {
        if (StringUtils.isBlank((CharSequence)skin.getCSSPath())) {
            LOG.debug("Ignore caching empty CSS file for module {}", new Object[]{skin.getModule()});
            return;
        }
        ExoContainerContext.setCurrentContainer((ExoContainer)PortalContainer.getInstance());
        String fullCSSPath = null;
        try {
            fullCSSPath = skin.createURL().toString();
            fullCSSPath = fullCSSPath.substring(0, fullCSSPath.indexOf("?"));
            this.getSkinModuleContent(fullCSSPath, skin.getFileContentHash(), Orientation.LT, !this.developing);
        }
        catch (Exception e) {
            LOG.warn("Error while initializing cache of CSS with path {}", new Object[]{fullCSSPath, e});
        }
        finally {
            ExoContainerContext.setCurrentContainer(null);
        }
    }

    @Generated
    public Map<Integer, File> getFiles() {
        return this.files;
    }

    @Generated
    public void setDeveloping(boolean developing) {
        this.developing = developing;
    }

    static {
        long seconds = 31536000L;
        String propValue = PropertyManager.getProperty((String)"gatein.assets.css.max-age");
        if (propValue != null) {
            try {
                seconds = Long.valueOf(propValue);
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)"The gatein.assets.css.max-age property is not set properly.");
            }
        }
        MAX_AGE = seconds;
    }

    static class SkinContext {
        final ControllerContext controller;
        final Orientation orientation;

        SkinContext(ControllerContext controller, Orientation orientation) {
            this.controller = controller;
            this.orientation = orientation;
        }
    }
}

