/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.query_rules;

import co.elastic.clients.elasticsearch.query_rules.list_rulesets.QueryRulesetListItem;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class ListRulesetsResponse
implements JsonpSerializable {
    private final long count;
    private final List<QueryRulesetListItem> results;
    public static final JsonpDeserializer<ListRulesetsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ListRulesetsResponse::setupListRulesetsResponseDeserializer);

    private ListRulesetsResponse(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0L);
        this.results = ApiTypeHelper.unmodifiableRequired(builder.results, (Object)this, "results");
    }

    public static ListRulesetsResponse of(Function<Builder, ObjectBuilder<ListRulesetsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long count() {
        return this.count;
    }

    public final List<QueryRulesetListItem> results() {
        return this.results;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        if (ApiTypeHelper.isDefined(this.results)) {
            generator.writeKey("results");
            generator.writeStartArray();
            for (QueryRulesetListItem item0 : this.results) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupListRulesetsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::results, JsonpDeserializer.arrayDeserializer(QueryRulesetListItem._DESERIALIZER), "results");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ListRulesetsResponse> {
        private Long count;
        private List<QueryRulesetListItem> results;

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder results(List<QueryRulesetListItem> list) {
            this.results = Builder._listAddAll(this.results, list);
            return this;
        }

        public final Builder results(QueryRulesetListItem value, QueryRulesetListItem ... values) {
            this.results = Builder._listAdd(this.results, value, values);
            return this;
        }

        public final Builder results(Function<QueryRulesetListItem.Builder, ObjectBuilder<QueryRulesetListItem>> fn) {
            return this.results(fn.apply(new QueryRulesetListItem.Builder()).build(), new QueryRulesetListItem[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ListRulesetsResponse build() {
            this._checkSingleUse();
            return new ListRulesetsResponse(this);
        }
    }
}

